/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.core.blockchain;

import com.exonum.binding.common.collect.MapEntry;
import com.exonum.binding.core.blockchain.Blockchain;
import com.exonum.binding.core.blockchain.CoreSchema;
import com.exonum.binding.core.blockchain.proofs.BlockProof;
import com.exonum.binding.core.storage.indices.MapIndexProxy;
import com.exonum.binding.core.storage.indices.MapProof;
import com.exonum.binding.core.storage.indices.ProofMapIndexProxy;
import com.exonum.messages.core.Blockchain;
import com.exonum.messages.core.Proofs;
import com.exonum.messages.core.runtime.Errors;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;

public final class CallRecords {
    private final Blockchain blockchain;
    private final long blockHeight;
    private final ProofMapIndexProxy<Blockchain.CallInBlock, Errors.ExecutionError> callErrors;
    private final MapIndexProxy<Blockchain.CallInBlock, Errors.ExecutionErrorAux> callErrorsAux;

    CallRecords(CoreSchema schema, Blockchain blockchain, long blockHeight) {
        this.blockchain = blockchain;
        this.blockHeight = blockHeight;
        this.callErrors = schema.getCallErrors(blockHeight);
        this.callErrorsAux = schema.getCallErrorsAux(blockHeight);
    }

    public Map<Blockchain.CallInBlock, Errors.ExecutionError> getErrors() {
        HashMap<Blockchain.CallInBlock, Errors.ExecutionError> mergedErrors = new HashMap<Blockchain.CallInBlock, Errors.ExecutionError>();
        Iterator<MapEntry<Blockchain.CallInBlock, Errors.ExecutionError>> callErrorsIter = this.callErrors.entries();
        while (callErrorsIter.hasNext()) {
            MapEntry<Blockchain.CallInBlock, Errors.ExecutionError> callErrorEntry = callErrorsIter.next();
            Blockchain.CallInBlock callId = (Blockchain.CallInBlock)callErrorEntry.getKey();
            Errors.ExecutionError callError = CallRecords.merge((Errors.ExecutionError)callErrorEntry.getValue(), this.callErrorsAux.get(callId));
            mergedErrors.put(callId, callError);
        }
        return mergedErrors;
    }

    public Optional<Errors.ExecutionError> get(Blockchain.CallInBlock callInBlock) {
        if (!this.callErrors.containsKey(callInBlock)) {
            return Optional.empty();
        }
        Errors.ExecutionError callError = this.callErrors.get(callInBlock);
        Errors.ExecutionErrorAux callErrorAuxInfo = this.callErrorsAux.get(callInBlock);
        return Optional.of(CallRecords.merge(callError, callErrorAuxInfo));
    }

    private static Errors.ExecutionError merge(Errors.ExecutionError executionError, Errors.ExecutionErrorAux executionErrorAuxInfo) {
        return Errors.ExecutionError.newBuilder((Errors.ExecutionError)executionError).setDescription(executionErrorAuxInfo.getDescription()).build();
    }

    public Proofs.CallProof getProof(Blockchain.CallInBlock callInBlock) {
        BlockProof blockProof = this.blockchain.createBlockProof(this.blockHeight);
        MapProof callErrorProof = this.callErrors.getProof(callInBlock, (Blockchain.CallInBlock[])new Blockchain.CallInBlock[0]);
        String description = this.callErrorsAux.containsKey(callInBlock) ? this.callErrorsAux.get(callInBlock).getDescription() : "";
        return Proofs.CallProof.newBuilder().setBlockProof(blockProof.getAsMessage()).setCallProof(callErrorProof.getAsMessage()).setErrorDescription(description).build();
    }
}

