/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.core.blockchain;

import com.exonum.binding.core.storage.database.Access;
import com.exonum.binding.core.util.LibraryLoader;
import com.exonum.messages.core.Proofs;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Optional;
import javax.annotation.Nullable;

final class BlockchainProofs {
    static Proofs.BlockProof createBlockProof(Access access, long height) {
        byte[] blockProof = BlockchainProofs.nativeCreateBlockProof(access.getAccessNativeHandle(), height);
        try {
            return Proofs.BlockProof.parseFrom((byte[])blockProof);
        }
        catch (InvalidProtocolBufferException e) {
            throw new AssertionError("Invalid block proof from native", e);
        }
    }

    static Optional<Proofs.IndexProof> createIndexProof(Access snapshot, String fullIndexName) {
        return Optional.ofNullable(BlockchainProofs.nativeCreateIndexProof(snapshot.getAccessNativeHandle(), fullIndexName)).map(proof -> {
            try {
                return Proofs.IndexProof.parseFrom((byte[])proof);
            }
            catch (InvalidProtocolBufferException e) {
                throw new AssertionError("Invalid index proof from native", e);
            }
        });
    }

    static native byte[] nativeCreateBlockProof(long var0, long var2);

    @Nullable
    static native byte[] nativeCreateIndexProof(long var0, String var2);

    private BlockchainProofs() {
    }

    static {
        LibraryLoader.load();
    }
}

