/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.core.blockchain;

import com.exonum.binding.core.blockchain.Blockchain;
import com.exonum.binding.core.blockchain.proofs.IndexProof;
import com.exonum.binding.core.proxy.AbstractNativeProxy;
import com.exonum.binding.core.proxy.Cleaner;
import com.exonum.binding.core.proxy.NativeHandle;
import com.exonum.binding.core.proxy.ProxyDestructor;
import com.exonum.binding.core.runtime.DispatcherSchema;
import com.exonum.binding.core.storage.database.AbstractAccess;
import com.exonum.binding.core.storage.database.Prefixed;
import com.exonum.binding.core.storage.database.RoErasedAccess;
import com.exonum.binding.core.util.LibraryLoader;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Optional;
import javax.annotation.Nullable;

public final class BlockchainData
extends AbstractNativeProxy {
    private final Cleaner cleaner;
    @Nullable
    private Prefixed executingServiceAccess;

    private BlockchainData(NativeHandle handle, Cleaner cleaner) {
        super(handle);
        this.cleaner = cleaner;
    }

    public static BlockchainData fromHandle(long bdNativeHandle, Cleaner cleaner) {
        Preconditions.checkNotNull((Object)cleaner);
        return BlockchainData.fromHandleInternal(bdNativeHandle, cleaner);
    }

    @VisibleForTesting
    public static BlockchainData fromRawAccess(AbstractAccess baseAccess, String serviceName) {
        Cleaner cleaner = baseAccess.getCleaner();
        long bdNativeHandle = BlockchainData.nativeCreate(baseAccess.getAccessNativeHandle(), serviceName);
        return BlockchainData.fromHandleInternal(bdNativeHandle, cleaner);
    }

    private static native long nativeCreate(long var0, String var2);

    private static BlockchainData fromHandleInternal(long bdNativeHandle, Cleaner cleaner) {
        NativeHandle handle = new NativeHandle(bdNativeHandle);
        ProxyDestructor.newRegistered(cleaner, handle, BlockchainData.class, BlockchainData::nativeFree);
        return new BlockchainData(handle, cleaner);
    }

    private static native void nativeFree(long var0);

    public Prefixed getExecutingServiceData() {
        if (this.executingServiceAccess == null) {
            long nativeHandle = this.getNativeHandle();
            long prefixedHandle = BlockchainData.nativeGetExecutingServiceAccess(nativeHandle);
            this.executingServiceAccess = Prefixed.fromHandle(prefixedHandle, this.cleaner);
        }
        return this.executingServiceAccess;
    }

    private static native long nativeGetExecutingServiceAccess(long var0);

    public Optional<Prefixed> findServiceData(String serviceName) {
        long prefixedHandle = BlockchainData.nativeFindServiceData(this.getNativeHandle(), serviceName);
        if (prefixedHandle == 0L) {
            return Optional.empty();
        }
        Prefixed access = Prefixed.fromHandle(prefixedHandle, this.cleaner);
        return Optional.of(access);
    }

    private static native long nativeFindServiceData(long var0, String var2);

    public IndexProof createIndexProof(String simpleIndexName) {
        String serviceName = BlockchainData.nativeGetServiceName(this.getNativeHandle());
        String fullIndexName = serviceName + "." + simpleIndexName;
        return this.getBlockchain().createIndexProof(fullIndexName);
    }

    private static native String nativeGetServiceName(long var0);

    public Blockchain getBlockchain() {
        return Blockchain.newInstance(this.getUnstructuredAccess());
    }

    public DispatcherSchema getDispatcherSchema() {
        return new DispatcherSchema(this.getUnstructuredAccess());
    }

    private RoErasedAccess getUnstructuredAccess() {
        long roAccessHandle = BlockchainData.nativeGetUnstructuredAccess(this.getNativeHandle());
        return RoErasedAccess.fromHandle(roAccessHandle, this.cleaner);
    }

    private static native long nativeGetUnstructuredAccess(long var0);

    static {
        LibraryLoader.load();
    }
}

