/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.core.blockchain;

import com.exonum.binding.common.blockchain.CallInBlocks;
import com.exonum.binding.common.blockchain.ExecutionStatuses;
import com.exonum.binding.common.blockchain.TransactionLocation;
import com.exonum.binding.common.hash.HashCode;
import com.exonum.binding.common.message.TransactionMessage;
import com.exonum.binding.core.blockchain.Block;
import com.exonum.binding.core.blockchain.BlockchainProofs;
import com.exonum.binding.core.blockchain.CallRecords;
import com.exonum.binding.core.blockchain.CoreSchema;
import com.exonum.binding.core.blockchain.proofs.BlockProof;
import com.exonum.binding.core.blockchain.proofs.IndexProof;
import com.exonum.binding.core.storage.database.Access;
import com.exonum.binding.core.storage.indices.KeySetIndexProxy;
import com.exonum.binding.core.storage.indices.ListIndex;
import com.exonum.binding.core.storage.indices.MapIndex;
import com.exonum.binding.core.storage.indices.ProofListIndexProxy;
import com.exonum.messages.core.Blockchain;
import com.exonum.messages.core.Proofs;
import com.exonum.messages.core.runtime.Errors;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Optional;

public final class Blockchain {
    private final Access access;
    private final CoreSchema schema;

    @VisibleForTesting
    Blockchain(Access access, CoreSchema schema) {
        this.access = access;
        this.schema = schema;
    }

    public static Blockchain newInstance(Access access) {
        CoreSchema coreSchema = CoreSchema.newInstance(access);
        return new Blockchain(access, coreSchema);
    }

    public BlockProof createBlockProof(long blockHeight) {
        this.checkHeight(blockHeight);
        Proofs.BlockProof blockProof = BlockchainProofs.createBlockProof(this.access, blockHeight);
        return BlockProof.newInstance(blockProof);
    }

    public IndexProof createIndexProof(String fullIndexName) {
        Preconditions.checkState((!this.access.canModify() ? 1 : 0) != 0, (String)"Cannot create an index proof for a mutable access (%s).", (Object)this.access);
        return BlockchainProofs.createIndexProof(this.access, fullIndexName).map(IndexProof::newInstance).orElseThrow(() -> new IllegalArgumentException(String.format("Index %s does not exist or is not Merkelized", fullIndexName)));
    }

    public boolean containsBlock(Block block) {
        return this.findBlock(block.getBlockHash()).map(block::equals).orElse(false);
    }

    public long getHeight() {
        return this.schema.getHeight();
    }

    public long getNextHeight() {
        return this.getBlockHashes().size();
    }

    public ListIndex<HashCode> getBlockHashes() {
        return this.schema.getBlockHashes();
    }

    public ProofListIndexProxy<HashCode> getBlockTransactions(long height) {
        return this.schema.getBlockTransactions(height);
    }

    public ProofListIndexProxy<HashCode> getBlockTransactions(HashCode blockId) {
        Optional<Block> block = this.findBlock(blockId);
        Preconditions.checkArgument((boolean)block.isPresent(), (String)"No block found for given id %s", (Object)blockId);
        return this.getBlockTransactions(block.get().getHeight());
    }

    public ProofListIndexProxy<HashCode> getBlockTransactions(Block block) {
        Preconditions.checkArgument((boolean)this.containsBlock(block), (String)"No such block (%s) in the database", (Object)block);
        return this.getBlockTransactions(block.getHeight());
    }

    public MapIndex<HashCode, TransactionMessage> getTxMessages() {
        return this.schema.getTxMessages();
    }

    public CallRecords getCallRecords(long blockHeight) {
        return new CallRecords(this.schema, this, blockHeight);
    }

    public Optional<Errors.ExecutionStatus> getTxResult(HashCode messageHash) {
        return this.getTxLocation(messageHash).map(this::getExecutionStatus);
    }

    private Errors.ExecutionStatus getExecutionStatus(TransactionLocation txLocation) {
        Blockchain.CallInBlock txCallId;
        long height = txLocation.getHeight();
        CallRecords callRecords = this.getCallRecords(height);
        Optional<Errors.ExecutionError> txErrorOpt = callRecords.get(txCallId = CallInBlocks.transaction((int)txLocation.getIndexInBlock()));
        if (txErrorOpt.isPresent()) {
            Errors.ExecutionError txError = txErrorOpt.get();
            return Errors.ExecutionStatus.newBuilder().setError(txError).build();
        }
        return ExecutionStatuses.SUCCESS;
    }

    public MapIndex<HashCode, TransactionLocation> getTxLocations() {
        return this.schema.getTxLocations();
    }

    public Optional<TransactionLocation> getTxLocation(HashCode messageHash) {
        MapIndex<HashCode, TransactionLocation> txLocations = this.getTxLocations();
        TransactionLocation transactionLocation = txLocations.get(messageHash);
        return Optional.ofNullable(transactionLocation);
    }

    public MapIndex<HashCode, Block> getBlocks() {
        return this.schema.getBlocks();
    }

    public Block getBlock(long height) {
        this.checkHeight(height);
        ListIndex<HashCode> blockHashes = this.getBlockHashes();
        HashCode blockHash = blockHashes.get(height);
        MapIndex<HashCode, Block> blocks = this.getBlocks();
        return blocks.get(blockHash);
    }

    private void checkHeight(long height) {
        long blockchainHeight = this.getHeight();
        if (height < 0L || height > blockchainHeight) {
            throw new IndexOutOfBoundsException("Block height (" + height + ") is out of range [0, " + blockchainHeight + "]");
        }
    }

    public Optional<Block> findBlock(HashCode blockHash) {
        MapIndex<HashCode, Block> blocks = this.getBlocks();
        Block block = blocks.get(blockHash);
        return Optional.ofNullable(block);
    }

    public Block getLastBlock() {
        ListIndex<HashCode> blockHashes = this.getBlockHashes();
        Preconditions.checkState((!blockHashes.isEmpty() ? 1 : 0) != 0, (Object)"No genesis block created yet (block hashes list is empty)");
        HashCode lastBlockHash = blockHashes.getLast();
        return this.getBlocks().get(lastBlockHash);
    }

    public Blockchain.Config getConsensusConfiguration() {
        return this.schema.getConsensusConfiguration();
    }

    public KeySetIndexProxy<HashCode> getTransactionPool() {
        return this.schema.getTransactionPool();
    }

    public long getNumTransactions() {
        return this.schema.getNumTransactions().orElse(0L);
    }
}

