/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.core.blockchain;

import com.exonum.binding.common.hash.HashCode;
import com.exonum.binding.common.hash.Hashing;
import com.exonum.binding.core.blockchain.$AutoValue_Block;
import com.exonum.binding.core.blockchain.AutoValue_Block;
import com.exonum.binding.core.blockchain.serialization.BlockSerializer;
import com.exonum.messages.core.Blockchain;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.protobuf.ByteString;

@AutoValue
public abstract class Block {
    public abstract HashCode getBlockHash();

    public abstract int getProposerId();

    public abstract long getHeight();

    public final boolean isEmpty() {
        return this.getNumTransactions() == 0;
    }

    public abstract int getNumTransactions();

    public abstract HashCode getPreviousBlockHash();

    public abstract HashCode getTxRootHash();

    public abstract HashCode getStateHash();

    public abstract HashCode getErrorHash();

    public abstract ImmutableMap<String, ByteString> getAdditionalHeaders();

    public int hashCode() {
        return this.getBlockHash().hashCode();
    }

    public static TypeAdapter<Block> typeAdapter(Gson gson) {
        return new AutoValue_Block.GsonTypeAdapter(gson);
    }

    public static Block fromMessage(Blockchain.Block blockMessage) {
        HashCode blockHash = Hashing.sha256().hashBytes(blockMessage.toByteArray());
        return BlockSerializer.newBlockInternal(blockMessage, blockHash);
    }

    public static Block parseFrom(byte[] serializedBlock) {
        return BlockSerializer.INSTANCE.fromBytes(serializedBlock);
    }

    public static Builder builder() {
        return new $AutoValue_Block.Builder();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder blockHash(HashCode var1);

        public abstract Builder proposerId(int var1);

        public abstract Builder height(long var1);

        public abstract Builder numTransactions(int var1);

        public abstract Builder previousBlockHash(HashCode var1);

        public abstract Builder txRootHash(HashCode var1);

        public abstract Builder stateHash(HashCode var1);

        public abstract Builder errorHash(HashCode var1);

        public abstract Builder additionalHeaders(ImmutableMap<String, ByteString> var1);

        abstract Block autoBuild();

        public Block build() {
            Block block = this.autoBuild();
            Preconditions.checkState((block.getHeight() >= 0L ? 1 : 0) != 0, (String)"Height is negative: %s", (long)block.getHeight());
            Preconditions.checkState((block.getNumTransactions() >= 0 ? 1 : 0) != 0, (String)"numTransaction is negative: %s", (int)block.getNumTransactions());
            return block;
        }
    }
}

