package com.exonum.binding.core.service;

import com.exonum.binding.common.crypto.PublicKey;
import com.exonum.binding.common.hash.HashCode;
import com.exonum.binding.core.blockchain.BlockchainData;
import java.util.Optional;
import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_InternalExecutionContext extends InternalExecutionContext {

  private final BlockchainData blockchainData;

  private final Optional<HashCode> transactionMessageHash;

  private final Optional<PublicKey> authorPk;

  private final String serviceName;

  private final int serviceId;

  AutoValue_InternalExecutionContext(
      BlockchainData blockchainData,
      Optional<HashCode> transactionMessageHash,
      Optional<PublicKey> authorPk,
      String serviceName,
      int serviceId) {
    if (blockchainData == null) {
      throw new NullPointerException("Null blockchainData");
    }
    this.blockchainData = blockchainData;
    if (transactionMessageHash == null) {
      throw new NullPointerException("Null transactionMessageHash");
    }
    this.transactionMessageHash = transactionMessageHash;
    if (authorPk == null) {
      throw new NullPointerException("Null authorPk");
    }
    this.authorPk = authorPk;
    if (serviceName == null) {
      throw new NullPointerException("Null serviceName");
    }
    this.serviceName = serviceName;
    this.serviceId = serviceId;
  }

  @Override
  public BlockchainData getBlockchainData() {
    return blockchainData;
  }

  @Override
  public Optional<HashCode> getTransactionMessageHash() {
    return transactionMessageHash;
  }

  @Override
  public Optional<PublicKey> getAuthorPk() {
    return authorPk;
  }

  @Override
  public String getServiceName() {
    return serviceName;
  }

  @Override
  public int getServiceId() {
    return serviceId;
  }

  @Override
  public String toString() {
    return "InternalExecutionContext{"
         + "blockchainData=" + blockchainData + ", "
         + "transactionMessageHash=" + transactionMessageHash + ", "
         + "authorPk=" + authorPk + ", "
         + "serviceName=" + serviceName + ", "
         + "serviceId=" + serviceId
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof InternalExecutionContext) {
      InternalExecutionContext that = (InternalExecutionContext) o;
      return this.blockchainData.equals(that.getBlockchainData())
          && this.transactionMessageHash.equals(that.getTransactionMessageHash())
          && this.authorPk.equals(that.getAuthorPk())
          && this.serviceName.equals(that.getServiceName())
          && this.serviceId == that.getServiceId();
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= blockchainData.hashCode();
    h$ *= 1000003;
    h$ ^= transactionMessageHash.hashCode();
    h$ *= 1000003;
    h$ ^= authorPk.hashCode();
    h$ *= 1000003;
    h$ ^= serviceName.hashCode();
    h$ *= 1000003;
    h$ ^= serviceId;
    return h$;
  }

}
