package com.exonum.binding.core.blockchain;

import com.exonum.binding.common.hash.HashCode;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.lang.SuppressWarnings;
import javax.annotation.processing.Generated;

@Generated(
    value = "com.ryanharter.auto.value.gson.AutoValueGsonExtension",
    comments = "https://github.com/rharter/auto-value-gson"
)
final class AutoValue_Block extends $AutoValue_Block {
  AutoValue_Block(HashCode blockHash, int proposerId, long height, int numTransactions,
      HashCode previousBlockHash, HashCode txRootHash, HashCode stateHash, HashCode errorHash,
      ImmutableMap<String, ByteString> additionalHeaders) {
    super(blockHash, proposerId, height, numTransactions, previousBlockHash, txRootHash, stateHash, errorHash, additionalHeaders);
  }

  static final class GsonTypeAdapter extends TypeAdapter<Block> {
    private volatile TypeAdapter<HashCode> hashCode_adapter;
    private volatile TypeAdapter<Integer> int__adapter;
    private volatile TypeAdapter<Long> long__adapter;
    private volatile TypeAdapter<ImmutableMap<String, ByteString>> immutableMap__string_byteString_adapter;
    private final Gson gson;
    GsonTypeAdapter(Gson gson) {
      this.gson = gson;
    }
    @Override
    @SuppressWarnings("unchecked")
    public void write(JsonWriter jsonWriter, Block object) throws IOException {
      if (object == null) {
        jsonWriter.nullValue();
        return;
      }
      jsonWriter.beginObject();
      jsonWriter.name("blockHash");
      if (object.getBlockHash() == null) {
        jsonWriter.nullValue();
      } else {
        TypeAdapter<HashCode> hashCode_adapter = this.hashCode_adapter;
        if (hashCode_adapter == null) {
          this.hashCode_adapter = hashCode_adapter = gson.getAdapter(HashCode.class);
        }
        hashCode_adapter.write(jsonWriter, object.getBlockHash());
      }
      jsonWriter.name("proposerId");
      {
        TypeAdapter<Integer> int__adapter = this.int__adapter;
        if (int__adapter == null) {
          this.int__adapter = int__adapter = gson.getAdapter(Integer.class);
        }
        int__adapter.write(jsonWriter, object.getProposerId());
      }
      jsonWriter.name("height");
      {
        TypeAdapter<Long> long__adapter = this.long__adapter;
        if (long__adapter == null) {
          this.long__adapter = long__adapter = gson.getAdapter(Long.class);
        }
        long__adapter.write(jsonWriter, object.getHeight());
      }
      jsonWriter.name("numTransactions");
      {
        TypeAdapter<Integer> int__adapter = this.int__adapter;
        if (int__adapter == null) {
          this.int__adapter = int__adapter = gson.getAdapter(Integer.class);
        }
        int__adapter.write(jsonWriter, object.getNumTransactions());
      }
      jsonWriter.name("previousBlockHash");
      if (object.getPreviousBlockHash() == null) {
        jsonWriter.nullValue();
      } else {
        TypeAdapter<HashCode> hashCode_adapter = this.hashCode_adapter;
        if (hashCode_adapter == null) {
          this.hashCode_adapter = hashCode_adapter = gson.getAdapter(HashCode.class);
        }
        hashCode_adapter.write(jsonWriter, object.getPreviousBlockHash());
      }
      jsonWriter.name("txRootHash");
      if (object.getTxRootHash() == null) {
        jsonWriter.nullValue();
      } else {
        TypeAdapter<HashCode> hashCode_adapter = this.hashCode_adapter;
        if (hashCode_adapter == null) {
          this.hashCode_adapter = hashCode_adapter = gson.getAdapter(HashCode.class);
        }
        hashCode_adapter.write(jsonWriter, object.getTxRootHash());
      }
      jsonWriter.name("stateHash");
      if (object.getStateHash() == null) {
        jsonWriter.nullValue();
      } else {
        TypeAdapter<HashCode> hashCode_adapter = this.hashCode_adapter;
        if (hashCode_adapter == null) {
          this.hashCode_adapter = hashCode_adapter = gson.getAdapter(HashCode.class);
        }
        hashCode_adapter.write(jsonWriter, object.getStateHash());
      }
      jsonWriter.name("errorHash");
      if (object.getErrorHash() == null) {
        jsonWriter.nullValue();
      } else {
        TypeAdapter<HashCode> hashCode_adapter = this.hashCode_adapter;
        if (hashCode_adapter == null) {
          this.hashCode_adapter = hashCode_adapter = gson.getAdapter(HashCode.class);
        }
        hashCode_adapter.write(jsonWriter, object.getErrorHash());
      }
      jsonWriter.name("additionalHeaders");
      if (object.getAdditionalHeaders() == null) {
        jsonWriter.nullValue();
      } else {
        TypeAdapter<ImmutableMap<String, ByteString>> immutableMap__string_byteString_adapter = this.immutableMap__string_byteString_adapter;
        if (immutableMap__string_byteString_adapter == null) {
          this.immutableMap__string_byteString_adapter = immutableMap__string_byteString_adapter = (TypeAdapter<ImmutableMap<String, ByteString>>) gson.getAdapter(TypeToken.getParameterized(ImmutableMap.class, String.class, ByteString.class));
        }
        immutableMap__string_byteString_adapter.write(jsonWriter, object.getAdditionalHeaders());
      }
      jsonWriter.endObject();
    }
    @Override
    @SuppressWarnings("unchecked")
    public Block read(JsonReader jsonReader) throws IOException {
      if (jsonReader.peek() == JsonToken.NULL) {
        jsonReader.nextNull();
        return null;
      }
      jsonReader.beginObject();
      Block.Builder builder = Block.builder();
      while (jsonReader.hasNext()) {
        String _name = jsonReader.nextName();
        if (jsonReader.peek() == JsonToken.NULL) {
          jsonReader.nextNull();
          continue;
        }
        switch (_name) {
          default: {
            if ("blockHash".equals(_name)) {
              TypeAdapter<HashCode> hashCode_adapter = this.hashCode_adapter;
              if (hashCode_adapter == null) {
                this.hashCode_adapter = hashCode_adapter = gson.getAdapter(HashCode.class);
              }
              builder.blockHash(hashCode_adapter.read(jsonReader));
              continue;
            }
            if ("proposerId".equals(_name)) {
              TypeAdapter<Integer> int__adapter = this.int__adapter;
              if (int__adapter == null) {
                this.int__adapter = int__adapter = gson.getAdapter(Integer.class);
              }
              builder.proposerId(int__adapter.read(jsonReader));
              continue;
            }
            if ("height".equals(_name)) {
              TypeAdapter<Long> long__adapter = this.long__adapter;
              if (long__adapter == null) {
                this.long__adapter = long__adapter = gson.getAdapter(Long.class);
              }
              builder.height(long__adapter.read(jsonReader));
              continue;
            }
            if ("numTransactions".equals(_name)) {
              TypeAdapter<Integer> int__adapter = this.int__adapter;
              if (int__adapter == null) {
                this.int__adapter = int__adapter = gson.getAdapter(Integer.class);
              }
              builder.numTransactions(int__adapter.read(jsonReader));
              continue;
            }
            if ("previousBlockHash".equals(_name)) {
              TypeAdapter<HashCode> hashCode_adapter = this.hashCode_adapter;
              if (hashCode_adapter == null) {
                this.hashCode_adapter = hashCode_adapter = gson.getAdapter(HashCode.class);
              }
              builder.previousBlockHash(hashCode_adapter.read(jsonReader));
              continue;
            }
            if ("txRootHash".equals(_name)) {
              TypeAdapter<HashCode> hashCode_adapter = this.hashCode_adapter;
              if (hashCode_adapter == null) {
                this.hashCode_adapter = hashCode_adapter = gson.getAdapter(HashCode.class);
              }
              builder.txRootHash(hashCode_adapter.read(jsonReader));
              continue;
            }
            if ("stateHash".equals(_name)) {
              TypeAdapter<HashCode> hashCode_adapter = this.hashCode_adapter;
              if (hashCode_adapter == null) {
                this.hashCode_adapter = hashCode_adapter = gson.getAdapter(HashCode.class);
              }
              builder.stateHash(hashCode_adapter.read(jsonReader));
              continue;
            }
            if ("errorHash".equals(_name)) {
              TypeAdapter<HashCode> hashCode_adapter = this.hashCode_adapter;
              if (hashCode_adapter == null) {
                this.hashCode_adapter = hashCode_adapter = gson.getAdapter(HashCode.class);
              }
              builder.errorHash(hashCode_adapter.read(jsonReader));
              continue;
            }
            if ("additionalHeaders".equals(_name)) {
              TypeAdapter<ImmutableMap<String, ByteString>> immutableMap__string_byteString_adapter = this.immutableMap__string_byteString_adapter;
              if (immutableMap__string_byteString_adapter == null) {
                this.immutableMap__string_byteString_adapter = immutableMap__string_byteString_adapter = (TypeAdapter<ImmutableMap<String, ByteString>>) gson.getAdapter(TypeToken.getParameterized(ImmutableMap.class, String.class, ByteString.class));
              }
              builder.additionalHeaders(immutableMap__string_byteString_adapter.read(jsonReader));
              continue;
            }
            jsonReader.skipValue();
          }
        }
      }
      jsonReader.endObject();
      return builder.build();
    }
    @Override
    public String toString() {
      return new StringBuilder().append("TypeAdapter(").append("Block").append(")").toString();
    }
  }
}
