package com.exonum.binding.core.blockchain;

import com.exonum.binding.common.hash.HashCode;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.ByteString;
import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
abstract class $AutoValue_Block extends Block {

  private final HashCode blockHash;

  private final int proposerId;

  private final long height;

  private final int numTransactions;

  private final HashCode previousBlockHash;

  private final HashCode txRootHash;

  private final HashCode stateHash;

  private final HashCode errorHash;

  private final ImmutableMap<String, ByteString> additionalHeaders;

  $AutoValue_Block(
      HashCode blockHash,
      int proposerId,
      long height,
      int numTransactions,
      HashCode previousBlockHash,
      HashCode txRootHash,
      HashCode stateHash,
      HashCode errorHash,
      ImmutableMap<String, ByteString> additionalHeaders) {
    if (blockHash == null) {
      throw new NullPointerException("Null blockHash");
    }
    this.blockHash = blockHash;
    this.proposerId = proposerId;
    this.height = height;
    this.numTransactions = numTransactions;
    if (previousBlockHash == null) {
      throw new NullPointerException("Null previousBlockHash");
    }
    this.previousBlockHash = previousBlockHash;
    if (txRootHash == null) {
      throw new NullPointerException("Null txRootHash");
    }
    this.txRootHash = txRootHash;
    if (stateHash == null) {
      throw new NullPointerException("Null stateHash");
    }
    this.stateHash = stateHash;
    if (errorHash == null) {
      throw new NullPointerException("Null errorHash");
    }
    this.errorHash = errorHash;
    if (additionalHeaders == null) {
      throw new NullPointerException("Null additionalHeaders");
    }
    this.additionalHeaders = additionalHeaders;
  }

  @Override
  public HashCode getBlockHash() {
    return blockHash;
  }

  @Override
  public int getProposerId() {
    return proposerId;
  }

  @Override
  public long getHeight() {
    return height;
  }

  @Override
  public int getNumTransactions() {
    return numTransactions;
  }

  @Override
  public HashCode getPreviousBlockHash() {
    return previousBlockHash;
  }

  @Override
  public HashCode getTxRootHash() {
    return txRootHash;
  }

  @Override
  public HashCode getStateHash() {
    return stateHash;
  }

  @Override
  public HashCode getErrorHash() {
    return errorHash;
  }

  @Override
  public ImmutableMap<String, ByteString> getAdditionalHeaders() {
    return additionalHeaders;
  }

  @Override
  public String toString() {
    return "Block{"
         + "blockHash=" + blockHash + ", "
         + "proposerId=" + proposerId + ", "
         + "height=" + height + ", "
         + "numTransactions=" + numTransactions + ", "
         + "previousBlockHash=" + previousBlockHash + ", "
         + "txRootHash=" + txRootHash + ", "
         + "stateHash=" + stateHash + ", "
         + "errorHash=" + errorHash + ", "
         + "additionalHeaders=" + additionalHeaders
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof Block) {
      Block that = (Block) o;
      return this.blockHash.equals(that.getBlockHash())
          && this.proposerId == that.getProposerId()
          && this.height == that.getHeight()
          && this.numTransactions == that.getNumTransactions()
          && this.previousBlockHash.equals(that.getPreviousBlockHash())
          && this.txRootHash.equals(that.getTxRootHash())
          && this.stateHash.equals(that.getStateHash())
          && this.errorHash.equals(that.getErrorHash())
          && this.additionalHeaders.equals(that.getAdditionalHeaders());
    }
    return false;
  }

  static class Builder extends Block.Builder {
    private HashCode blockHash;
    private Integer proposerId;
    private Long height;
    private Integer numTransactions;
    private HashCode previousBlockHash;
    private HashCode txRootHash;
    private HashCode stateHash;
    private HashCode errorHash;
    private ImmutableMap<String, ByteString> additionalHeaders;
    Builder() {
    }
    @Override
    public Block.Builder blockHash(HashCode blockHash) {
      if (blockHash == null) {
        throw new NullPointerException("Null blockHash");
      }
      this.blockHash = blockHash;
      return this;
    }
    @Override
    public Block.Builder proposerId(int proposerId) {
      this.proposerId = proposerId;
      return this;
    }
    @Override
    public Block.Builder height(long height) {
      this.height = height;
      return this;
    }
    @Override
    public Block.Builder numTransactions(int numTransactions) {
      this.numTransactions = numTransactions;
      return this;
    }
    @Override
    public Block.Builder previousBlockHash(HashCode previousBlockHash) {
      if (previousBlockHash == null) {
        throw new NullPointerException("Null previousBlockHash");
      }
      this.previousBlockHash = previousBlockHash;
      return this;
    }
    @Override
    public Block.Builder txRootHash(HashCode txRootHash) {
      if (txRootHash == null) {
        throw new NullPointerException("Null txRootHash");
      }
      this.txRootHash = txRootHash;
      return this;
    }
    @Override
    public Block.Builder stateHash(HashCode stateHash) {
      if (stateHash == null) {
        throw new NullPointerException("Null stateHash");
      }
      this.stateHash = stateHash;
      return this;
    }
    @Override
    public Block.Builder errorHash(HashCode errorHash) {
      if (errorHash == null) {
        throw new NullPointerException("Null errorHash");
      }
      this.errorHash = errorHash;
      return this;
    }
    @Override
    public Block.Builder additionalHeaders(ImmutableMap<String, ByteString> additionalHeaders) {
      if (additionalHeaders == null) {
        throw new NullPointerException("Null additionalHeaders");
      }
      this.additionalHeaders = additionalHeaders;
      return this;
    }
    @Override
    Block autoBuild() {
      String missing = "";
      if (this.blockHash == null) {
        missing += " blockHash";
      }
      if (this.proposerId == null) {
        missing += " proposerId";
      }
      if (this.height == null) {
        missing += " height";
      }
      if (this.numTransactions == null) {
        missing += " numTransactions";
      }
      if (this.previousBlockHash == null) {
        missing += " previousBlockHash";
      }
      if (this.txRootHash == null) {
        missing += " txRootHash";
      }
      if (this.stateHash == null) {
        missing += " stateHash";
      }
      if (this.errorHash == null) {
        missing += " errorHash";
      }
      if (this.additionalHeaders == null) {
        missing += " additionalHeaders";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_Block(
          this.blockHash,
          this.proposerId,
          this.height,
          this.numTransactions,
          this.previousBlockHash,
          this.txRootHash,
          this.stateHash,
          this.errorHash,
          this.additionalHeaders);
    }
  }

}
