/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.storage.indices;

import com.exonum.binding.proxy.Cleaner;
import com.exonum.binding.proxy.NativeHandle;
import com.exonum.binding.proxy.ProxyDestructor;
import com.exonum.binding.storage.database.View;
import com.exonum.binding.storage.indices.AbstractIndexProxy;
import com.exonum.binding.storage.indices.MapEntry;
import com.exonum.binding.storage.indices.MapEntryInternal;
import com.exonum.binding.storage.indices.MapIndex;
import com.exonum.binding.storage.indices.StorageIterators;
import com.exonum.binding.storage.indices.StoragePreconditions;
import com.exonum.binding.storage.serialization.CheckingSerializerDecorator;
import com.exonum.binding.storage.serialization.Serializer;
import java.util.Iterator;
import java.util.Map;
import java.util.function.LongSupplier;

public final class MapIndexProxy<K, V>
extends AbstractIndexProxy
implements MapIndex<K, V> {
    private final CheckingSerializerDecorator<K> keySerializer;
    private final CheckingSerializerDecorator<V> valueSerializer;

    public static <K, V> MapIndexProxy<K, V> newInstance(String name, View view, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        StoragePreconditions.checkIndexName(name);
        CheckingSerializerDecorator ks = CheckingSerializerDecorator.from(keySerializer);
        CheckingSerializerDecorator vs = CheckingSerializerDecorator.from(valueSerializer);
        long viewNativeHandle = view.getViewNativeHandle();
        NativeHandle mapNativeHandle = MapIndexProxy.createNativeMap(view, () -> MapIndexProxy.nativeCreate(name, viewNativeHandle));
        return new MapIndexProxy<K, V>(mapNativeHandle, name, view, ks, vs);
    }

    public static <K, V> MapIndexProxy<K, V> newInGroupUnsafe(String groupName, byte[] mapId, View view, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        StoragePreconditions.checkIndexName(groupName);
        StoragePreconditions.checkIdInGroup(mapId);
        CheckingSerializerDecorator ks = CheckingSerializerDecorator.from(keySerializer);
        CheckingSerializerDecorator vs = CheckingSerializerDecorator.from(valueSerializer);
        long viewNativeHandle = view.getViewNativeHandle();
        NativeHandle mapNativeHandle = MapIndexProxy.createNativeMap(view, () -> MapIndexProxy.nativeCreateInGroup(groupName, mapId, viewNativeHandle));
        return new MapIndexProxy<K, V>(mapNativeHandle, groupName, view, ks, vs);
    }

    private static NativeHandle createNativeMap(View view, LongSupplier nativeMapConstructor) {
        NativeHandle mapNativeHandle = new NativeHandle(nativeMapConstructor.getAsLong());
        Cleaner cleaner = view.getCleaner();
        ProxyDestructor.newRegistered(cleaner, mapNativeHandle, MapIndexProxy.class, MapIndexProxy::nativeFree);
        return mapNativeHandle;
    }

    private MapIndexProxy(NativeHandle nativeHandle, String name, View view, CheckingSerializerDecorator<K> keySerializer, CheckingSerializerDecorator<V> valueSerializer) {
        super(nativeHandle, name, view);
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
    }

    @Override
    public boolean containsKey(K key) {
        byte[] dbKey = this.keySerializer.toBytes(key);
        return this.nativeContainsKey(this.getNativeHandle(), dbKey);
    }

    @Override
    public void put(K key, V value) {
        this.notifyModified();
        this.putInternal(this.getNativeHandle(), key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> sourceMap) {
        this.notifyModified();
        long nativeHandle = this.getNativeHandle();
        for (Map.Entry<K, V> entry : sourceMap.entrySet()) {
            this.putInternal(nativeHandle, entry.getKey(), entry.getValue());
        }
    }

    private void putInternal(long thisNativeHandle, K key, V value) {
        byte[] dbKey = this.keySerializer.toBytes(key);
        byte[] dbValue = this.valueSerializer.toBytes(value);
        this.nativePut(thisNativeHandle, dbKey, dbValue);
    }

    @Override
    public V get(K key) {
        byte[] dbKey = this.keySerializer.toBytes(key);
        byte[] dbValue = this.nativeGet(this.getNativeHandle(), dbKey);
        return (V)(dbValue == null ? null : this.valueSerializer.fromBytes(dbValue));
    }

    @Override
    public void remove(K key) {
        this.notifyModified();
        byte[] dbKey = this.keySerializer.toBytes(key);
        this.nativeRemove(this.getNativeHandle(), dbKey);
    }

    @Override
    public Iterator<K> keys() {
        return StorageIterators.createIterator(this.nativeCreateKeysIter(this.getNativeHandle()), this::nativeKeysIterNext, this::nativeKeysIterFree, this.dbView, this.modCounter, arg_0 -> this.keySerializer.fromBytes(arg_0));
    }

    @Override
    public Iterator<V> values() {
        return StorageIterators.createIterator(this.nativeCreateValuesIter(this.getNativeHandle()), this::nativeValuesIterNext, this::nativeValuesIterFree, this.dbView, this.modCounter, arg_0 -> this.valueSerializer.fromBytes(arg_0));
    }

    @Override
    public Iterator<MapEntry<K, V>> entries() {
        return StorageIterators.createIterator(this.nativeCreateEntriesIter(this.getNativeHandle()), this::nativeEntriesIterNext, this::nativeEntriesIterFree, this.dbView, this.modCounter, entry -> MapEntry.fromInternal(entry, this.keySerializer, this.valueSerializer));
    }

    private native long nativeCreateEntriesIter(long var1);

    private native MapEntryInternal nativeEntriesIterNext(long var1);

    private native void nativeEntriesIterFree(long var1);

    @Override
    public void clear() {
        this.notifyModified();
        this.nativeClear(this.getNativeHandle());
    }

    private static native long nativeCreate(String var0, long var1);

    private static native long nativeCreateInGroup(String var0, byte[] var1, long var2);

    private native boolean nativeContainsKey(long var1, byte[] var3);

    private native void nativePut(long var1, byte[] var3, byte[] var4);

    private native byte[] nativeGet(long var1, byte[] var3);

    private native void nativeRemove(long var1, byte[] var3);

    private native long nativeCreateKeysIter(long var1);

    private native byte[] nativeKeysIterNext(long var1);

    private native void nativeKeysIterFree(long var1);

    private native long nativeCreateValuesIter(long var1);

    private native byte[] nativeValuesIterNext(long var1);

    private native void nativeValuesIterFree(long var1);

    private native void nativeClear(long var1);

    private static native void nativeFree(long var0);
}

