/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.storage.indices;

import com.exonum.binding.proxy.Cleaner;
import com.exonum.binding.proxy.NativeHandle;
import com.exonum.binding.proxy.ProxyDestructor;
import com.exonum.binding.storage.database.View;
import com.exonum.binding.storage.indices.AbstractIndexProxy;
import com.exonum.binding.storage.indices.StoragePreconditions;
import com.exonum.binding.storage.serialization.CheckingSerializerDecorator;
import com.exonum.binding.storage.serialization.Serializer;
import java.util.NoSuchElementException;

public final class EntryIndexProxy<T>
extends AbstractIndexProxy {
    private final CheckingSerializerDecorator<T> serializer;

    public static <E> EntryIndexProxy<E> newInstance(String name, View view, Serializer<E> serializer) {
        StoragePreconditions.checkIndexName(name);
        CheckingSerializerDecorator s = CheckingSerializerDecorator.from(serializer);
        NativeHandle entryNativeHandle = EntryIndexProxy.createNativeEntry(name, view);
        return new EntryIndexProxy(entryNativeHandle, name, view, s);
    }

    private static NativeHandle createNativeEntry(String name, View view) {
        long viewNativeHandle = view.getViewNativeHandle();
        NativeHandle entryNativeHandle = new NativeHandle(EntryIndexProxy.nativeCreate(name, viewNativeHandle));
        Cleaner cleaner = view.getCleaner();
        ProxyDestructor.newRegistered(cleaner, entryNativeHandle, EntryIndexProxy.class, EntryIndexProxy::nativeFree);
        return entryNativeHandle;
    }

    private EntryIndexProxy(NativeHandle nativeHandle, String name, View view, CheckingSerializerDecorator<T> serializer) {
        super(nativeHandle, name, view);
        this.serializer = serializer;
    }

    public void set(T value) {
        this.notifyModified();
        byte[] valueBytes = this.serializer.toBytes(value);
        this.nativeSet(this.getNativeHandle(), valueBytes);
    }

    public boolean isPresent() {
        return this.nativeIsPresent(this.getNativeHandle());
    }

    public T get() {
        byte[] value = this.nativeGet(this.getNativeHandle());
        if (value == null) {
            throw new NoSuchElementException("No value in this entry");
        }
        return (T)this.serializer.fromBytes(value);
    }

    public void remove() {
        this.notifyModified();
        this.nativeRemove(this.getNativeHandle());
    }

    private static native long nativeCreate(String var0, long var1);

    private native void nativeSet(long var1, byte[] var3);

    private native boolean nativeIsPresent(long var1);

    private native byte[] nativeGet(long var1);

    private native byte[] nativeGetHash(long var1);

    private native void nativeRemove(long var1);

    private static native void nativeFree(long var0);
}

