/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.service.adapters;

import com.exonum.binding.hash.HashCode;
import com.exonum.binding.messages.BinaryMessage;
import com.exonum.binding.messages.Transaction;
import com.exonum.binding.proxy.Cleaner;
import com.exonum.binding.proxy.CloseFailuresException;
import com.exonum.binding.service.NodeProxy;
import com.exonum.binding.service.Service;
import com.exonum.binding.service.adapters.UserTransactionAdapter;
import com.exonum.binding.service.adapters.ViewFactory;
import com.exonum.binding.storage.database.Fork;
import com.exonum.binding.storage.database.Snapshot;
import com.exonum.binding.transport.Server;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import io.vertx.ext.web.Router;
import java.util.List;
import javax.annotation.Nullable;

public class UserServiceAdapter {
    private final Service service;
    private final Server server;
    private final ViewFactory viewFactory;
    @Nullable
    private NodeProxy node;

    @Inject
    public UserServiceAdapter(Service service, Server server, ViewFactory viewFactory) {
        this.service = (Service)Preconditions.checkNotNull((Object)service, (Object)"service");
        this.server = (Server)Preconditions.checkNotNull((Object)server, (Object)"server");
        this.viewFactory = (ViewFactory)Preconditions.checkNotNull((Object)viewFactory, (Object)"viewFactory");
    }

    public short getId() {
        return this.service.getId();
    }

    public String getName() {
        return this.service.getName();
    }

    public UserTransactionAdapter convertTransaction(byte[] transactionMessage) {
        BinaryMessage message = BinaryMessage.fromBytes(transactionMessage);
        assert (message.getServiceId() == this.getId()) : "Message id is distinct from the service id";
        Transaction transaction = this.service.convertToTransaction(message);
        Preconditions.checkNotNull((Object)transaction, (String)"Invalid service implementation: Service#convertToTransaction must never return null.\nThrow an exception if your service does not recognize this message id (%s)", (int)message.getMessageType());
        return new UserTransactionAdapter(transaction, this.viewFactory);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[][] getStateHashes(long snapshotHandle) {
        assert (snapshotHandle != 0L);
        try (Cleaner cleaner = new Cleaner("UserServiceAdapter#getStateHashes");){
            Snapshot snapshot = this.viewFactory.createSnapshot(snapshotHandle, cleaner);
            List<HashCode> stateHashes = this.service.getStateHashes(snapshot);
            byte[][] byArray = (byte[][])stateHashes.stream().map(HashCode::asBytes).toArray(x$0 -> new byte[x$0][]);
            return byArray;
        }
        catch (CloseFailuresException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public String initialize(long forkHandle) {
        assert (forkHandle != 0L);
        try (Cleaner cleaner = new Cleaner("UserServiceAdapter#initialize");){
            Fork fork = this.viewFactory.createFork(forkHandle, cleaner);
            String string = this.service.initialize(fork).orElse(null);
            return string;
        }
        catch (CloseFailuresException e) {
            throw new RuntimeException(e);
        }
    }

    public void mountPublicApiHandler(long nodeNativeHandle) {
        Preconditions.checkState((this.node == null ? 1 : 0) != 0, (Object)"There is a node already: are you calling this method twice?");
        this.node = new NodeProxy(nodeNativeHandle, this.viewFactory);
        Router router = this.server.createRouter();
        this.service.createPublicApiHandlers(this.node, router);
        this.server.mountSubRouter("/" + this.getName(), router);
    }

    public void close() {
        if (this.node != null) {
            this.node.close();
        }
    }
}

