/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.service;

import com.exonum.binding.hash.HashCode;
import com.exonum.binding.messages.BinaryMessage;
import com.exonum.binding.messages.Transaction;
import com.exonum.binding.service.Schema;
import com.exonum.binding.service.Service;
import com.exonum.binding.service.TransactionConverter;
import com.exonum.binding.storage.database.Snapshot;
import com.exonum.binding.storage.database.View;
import com.google.common.base.Preconditions;
import java.util.List;

public abstract class AbstractService
implements Service {
    private final short id;
    private final String name;
    private final TransactionConverter transactionConverter;

    protected AbstractService(short id, String name, TransactionConverter transactionConverter) {
        this.id = id;
        Preconditions.checkArgument((!name.isEmpty() ? 1 : 0) != 0, (Object)"The service name must not be empty");
        this.name = name;
        this.transactionConverter = (TransactionConverter)Preconditions.checkNotNull((Object)transactionConverter);
    }

    @Override
    public short getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Transaction convertToTransaction(BinaryMessage message) {
        return this.transactionConverter.toTransaction(message);
    }

    @Override
    public List<HashCode> getStateHashes(Snapshot snapshot) {
        return this.createDataSchema(snapshot).getStateHashes();
    }

    protected abstract Schema createDataSchema(View var1);
}

