/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.proxy;

import com.google.common.base.Preconditions;

public final class NativeHandle
implements AutoCloseable {
    public static final long INVALID_NATIVE_HANDLE = 0L;
    private long nativeHandle;

    public NativeHandle(long nativeHandle) {
        this.nativeHandle = nativeHandle;
    }

    public long get() {
        this.checkValid();
        return this.nativeHandle;
    }

    @Override
    public void close() {
        if (this.isValid()) {
            this.invalidate();
        }
    }

    private void checkValid() {
        Preconditions.checkState((boolean)this.isValid(), (String)"This handle is not valid: %s", (Object)this);
    }

    final boolean isValid() {
        return this.nativeHandle != 0L;
    }

    private void invalidate() {
        this.nativeHandle = 0L;
    }
}

