/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.service;

import com.exonum.binding.messages.BinaryMessage;
import com.exonum.binding.messages.InternalServerError;
import com.exonum.binding.messages.InvalidTransactionException;
import com.exonum.binding.messages.Transaction;
import com.exonum.binding.proxy.AbstractCloseableNativeProxy;
import com.exonum.binding.proxy.Cleaner;
import com.exonum.binding.proxy.CloseFailuresException;
import com.exonum.binding.service.Node;
import com.exonum.binding.service.adapters.UserTransactionAdapter;
import com.exonum.binding.service.adapters.ViewFactory;
import com.exonum.binding.storage.database.Snapshot;
import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class NodeProxy
extends AbstractCloseableNativeProxy
implements Node {
    private static final Logger logger = LogManager.getLogger(NodeProxy.class);
    private final ViewFactory viewFactory;

    public NodeProxy(long nativeHandle, ViewFactory viewFactory) {
        super(nativeHandle, false);
        this.viewFactory = viewFactory;
    }

    @Override
    public void submitTransaction(Transaction transaction) throws InvalidTransactionException, InternalServerError {
        BinaryMessage message = transaction.getMessage();
        ByteBuffer messageBuffer = message.getSignedMessage();
        Preconditions.checkArgument((boolean)messageBuffer.hasArray(), (String)"The byte buffer does not provide an array (it is either a direct or read-only). direct=%s, ro=%s", (Object)messageBuffer.isDirect(), (Object)messageBuffer.isReadOnly());
        byte[] data = messageBuffer.array();
        int offset = messageBuffer.arrayOffset();
        int size = messageBuffer.remaining();
        UserTransactionAdapter txAdapter = new UserTransactionAdapter(transaction, this.viewFactory);
        NodeProxy.nativeSubmit(this.getNativeHandle(), txAdapter, data, offset, size);
    }

    private static native void nativeSubmit(long var0, UserTransactionAdapter var2, byte[] var3, int var4, int var5) throws InvalidTransactionException, InternalServerError;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <ResultT> ResultT withSnapshot(Function<Snapshot, ResultT> snapshotFunction) {
        try (Cleaner cleaner = new Cleaner("NodeProxy#withSnapshot");){
            long nodeNativeHandle = this.getNativeHandle();
            long snapshotNativeHandle = this.nativeCreateSnapshot(nodeNativeHandle);
            Snapshot snapshot = Snapshot.newInstance(snapshotNativeHandle, cleaner);
            ResultT ResultT = snapshotFunction.apply(snapshot);
            return ResultT;
        }
        catch (CloseFailuresException e) {
            logger.error((Object)e);
            throw new RuntimeException(e);
        }
    }

    private native long nativeCreateSnapshot(long var1);

    @Override
    public byte[] getPublicKey() {
        return this.nativeGetPublicKey(this.getNativeHandle());
    }

    private native byte[] nativeGetPublicKey(long var1);

    @Override
    protected void disposeInternal() {
    }
}

