/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.messages;

import com.exonum.binding.crypto.CryptoFunction;
import com.exonum.binding.crypto.PrivateKey;
import com.exonum.binding.crypto.PublicKey;
import com.exonum.binding.hash.HashCode;
import com.exonum.binding.hash.HashFunction;
import com.exonum.binding.hash.Hashing;
import com.exonum.binding.messages.Message;
import com.exonum.binding.messages.MessageReader;
import com.google.errorprone.annotations.CheckReturnValue;
import java.nio.ByteBuffer;

public interface BinaryMessage
extends Message {
    public static BinaryMessage fromBytes(byte[] messageBytes) {
        ByteBuffer buf = ByteBuffer.wrap(messageBytes);
        return MessageReader.wrap(buf);
    }

    default public byte[] getMessageNoSignature() {
        ByteBuffer signedMessage = this.getSignedMessage();
        int fullSize = signedMessage.remaining();
        int messageSize = fullSize - 64;
        byte[] message = new byte[messageSize];
        signedMessage.get(message);
        return message;
    }

    @CheckReturnValue
    default public BinaryMessage sign(CryptoFunction cryptoFunction, PrivateKey authorSecretKey) {
        BinaryMessage unsignedPacket = this;
        byte[] message = unsignedPacket.getMessageNoSignature();
        byte[] signature = cryptoFunction.signMessage(message, authorSecretKey);
        return new Message.Builder().mergeFrom(unsignedPacket).setSignature(signature).buildRaw();
    }

    @CheckReturnValue
    default public boolean verify(CryptoFunction cryptoFunction, PublicKey authorPublicKey) {
        byte[] message = this.getMessageNoSignature();
        byte[] signature = this.getSignature();
        return cryptoFunction.verify(message, signature, authorPublicKey);
    }

    public ByteBuffer getSignedMessage();

    default public HashCode hash() {
        HashFunction hashFunction = Hashing.defaultHashFunction();
        return hashFunction.hashBytes(this.getSignedMessage());
    }
}

