/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.crypto;

import com.exonum.binding.crypto.PrivateKey;
import com.exonum.binding.crypto.PublicKey;

public class KeyPair {
    private final PublicKey publicKey;
    private final PrivateKey privateKey;

    private KeyPair(byte[] privateKey, byte[] publicKey) {
        this.privateKey = PrivateKey.fromBytesNoCopy(privateKey);
        this.publicKey = PublicKey.fromBytesNoCopy(publicKey);
    }

    public static KeyPair createKeyPair(byte[] privateKey, byte[] publicKey) {
        return KeyPair.createKeyPairNoCopy((byte[])privateKey.clone(), (byte[])publicKey.clone());
    }

    static KeyPair createKeyPairNoCopy(byte[] privateKey, byte[] publicKey) {
        return new KeyPair(privateKey, publicKey);
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }
}

