/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.storage.indices;

import com.exonum.binding.proxy.AbstractNativeProxy;
import com.exonum.binding.proxy.NativeHandle;
import com.exonum.binding.storage.database.View;
import com.exonum.binding.storage.database.ViewModificationCounter;
import com.exonum.binding.storage.indices.RustIter;
import java.util.ConcurrentModificationException;
import java.util.Optional;
import java.util.function.LongFunction;

final class ConfigurableRustIter<E>
extends AbstractNativeProxy
implements RustIter<E> {
    private final LongFunction<E> nextFunction;
    private final View collectionView;
    private final ViewModificationCounter modificationCounter;
    private final Integer initialModCount;

    ConfigurableRustIter(NativeHandle nativeHandle, LongFunction<E> nextFunction, View collectionView, ViewModificationCounter modificationCounter) {
        super(nativeHandle);
        this.nextFunction = nextFunction;
        this.collectionView = collectionView;
        this.modificationCounter = modificationCounter;
        this.initialModCount = modificationCounter.getModificationCount(collectionView);
    }

    @Override
    public Optional<E> next() {
        this.checkNotModified();
        return Optional.ofNullable(this.nextFunction.apply(this.getNativeHandle()));
    }

    private void checkNotModified() {
        if (this.modificationCounter.isModifiedSince(this.collectionView, this.initialModCount)) {
            throw new ConcurrentModificationException("Fork was modified during iteration: " + this.collectionView);
        }
    }
}

