/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.service;

import com.exonum.binding.service.FrameworkModule;
import com.exonum.binding.service.adapters.UserServiceAdapter;
import com.exonum.binding.transport.Server;
import com.exonum.binding.util.LibraryLoader;
import com.google.common.base.Preconditions;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.ExecutionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

final class ServiceBootstrap {
    private static final Logger logger = LogManager.getLogger(ServiceBootstrap.class);

    ServiceBootstrap() {
    }

    static UserServiceAdapter startService(String serviceModuleName, int serverPort) {
        try {
            Injector injector = Guice.createInjector((Module[])new Module[]{new FrameworkModule(), ServiceBootstrap.createUserModule(serviceModuleName)});
            Server server = (Server)injector.getInstance(Server.class);
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                try {
                    server.stop().get();
                }
                catch (InterruptedException | ExecutionException e) {
                    logger.warn("Failed to stop the server during VM shutdown", (Throwable)e);
                }
            }));
            server.start(serverPort);
            LibraryLoader.load();
            return (UserServiceAdapter)injector.getInstance(UserServiceAdapter.class);
        }
        catch (Throwable t) {
            logger.fatal("Failed to start service {}:", (Object)serviceModuleName, (Object)t);
            throw t;
        }
    }

    private static Module createUserModule(String moduleName) {
        try {
            Class<?> moduleClass = Class.forName(moduleName);
            Constructor<?> constructor = moduleClass.getDeclaredConstructor(new Class[0]);
            Object moduleObject = constructor.newInstance(new Object[0]);
            Preconditions.checkArgument((boolean)(moduleObject instanceof Module), (String)"%s is not a sub-class of %s", moduleClass, (Object)Module.class.getCanonicalName());
            return (Module)moduleObject;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Module class cannot be found", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Cannot access the no-arg module constructor", e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("No no-arg constructor", e);
        }
        catch (InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

