/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.messages;

import com.exonum.binding.messages.BinaryMessage;
import com.exonum.binding.messages.BinaryMessageBuilder;
import com.exonum.binding.messages.Message_Builder2;
import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;

public interface Message {
    public static final int NET_ID_OFFSET = 0;
    public static final int VERSION_OFFSET = 1;
    public static final int MESSAGE_TYPE_OFFSET = 2;
    public static final int SERVICE_ID_OFFSET = 4;
    public static final int PAYLOAD_LENGTH_OFFSET = 6;
    public static final int HEADER_SIZE = 10;
    public static final int BODY_OFFSET = 10;
    public static final int SIGNATURE_SIZE = 64;
    public static final int MAX_BODY_SIZE = 2147483573;

    public static int messageSize(int bodySize) {
        Preconditions.checkArgument((0 <= bodySize && bodySize <= 2147483573 ? 1 : 0) != 0, (String)"Body size (%s) is invalid", (int)bodySize);
        return 10 + bodySize + 64;
    }

    public byte getNetworkId();

    public byte getVersion();

    public short getServiceId();

    public short getMessageType();

    public ByteBuffer getBody();

    public ByteBuffer getSignature();

    default public int signatureOffset() {
        return this.size() - 64;
    }

    default public int size() {
        return Message.messageSize(this.getBody().remaining());
    }

    public static class Builder
    extends Message_Builder2 {
        private static final byte DEFAULT_NETWORK_ID = 0;
        private static final byte DEFAULT_PROTOCOL_VERSION = 0;

        public Builder() {
            this.setNetworkId((byte)0);
            this.setVersion((byte)0);
        }

        @Override
        public Builder setBody(ByteBuffer body) {
            int bodySize = body.remaining();
            Preconditions.checkArgument((bodySize <= 2147483573 ? 1 : 0) != 0, (String)"The body is too big (%s)", (int)bodySize);
            return super.setBody(body.duplicate());
        }

        @Override
        public Builder setSignature(ByteBuffer signature) {
            int signatureSize = signature.remaining();
            Preconditions.checkArgument((signatureSize == 64 ? 1 : 0) != 0, (String)"Invalid signature size (%s)", (int)signatureSize);
            return super.setSignature(signature.duplicate());
        }

        public BinaryMessage buildRaw() {
            Message message = this.build();
            return BinaryMessageBuilder.toBinary(message);
        }
    }
}

