/*
 * Decompiled with CFR 0.152.
 */
package com.excellence.permission.support;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.util.Log;
import com.excellence.permission.support.HUAWEI;
import com.excellence.permission.support.MEIZU;
import com.excellence.permission.support.OPPO;
import com.excellence.permission.support.PermissionPage;
import com.excellence.permission.support.Protogenesis;
import com.excellence.permission.support.VIVO;
import com.excellence.permission.support.XIAOMI;

public class PermissionPageManager {
    public static final String TAG = PermissionPageManager.class.getSimpleName();
    private static final String MANUFACTURER = Build.MANUFACTURER.toUpperCase();
    private static final String MANUFACTURER_HUAWEI = "HUAWEI";
    protected static final String MANUFACTURER_XIAOMI = "XIAOMI";
    protected static final String MANUFACTURER_OPPO = "OPPO";
    private static final String MANUFACTURER_VIVO = "VIVO";
    protected static final String MANUFACTURER_MEIZU = "MEIZU";

    public static String getManufacturer() {
        return MANUFACTURER;
    }

    public static Intent getSettingIntent(Context context) {
        Log.i((String)TAG, (String)("****\u624b\u673a\u578b\u53f7****" + MANUFACTURER));
        try {
            PermissionPage permissionPage;
            switch (MANUFACTURER) {
                case "HUAWEI": {
                    permissionPage = new HUAWEI(context);
                    break;
                }
                case "XIAOMI": {
                    permissionPage = new XIAOMI(context);
                    break;
                }
                case "OPPO": {
                    permissionPage = new OPPO(context);
                    break;
                }
                case "VIVO": {
                    permissionPage = new VIVO(context);
                    break;
                }
                case "MEIZU": {
                    permissionPage = new MEIZU(context);
                    break;
                }
                default: {
                    permissionPage = new Protogenesis(context);
                }
            }
            return permissionPage.settingIntent();
        }
        catch (Exception e) {
            e.printStackTrace();
            Protogenesis permissionPage = new Protogenesis(context);
            return permissionPage.settingIntent();
        }
    }

    public static boolean isXIAOMO() {
        return PermissionPageManager.getManufacturer().equalsIgnoreCase(MANUFACTURER_XIAOMI);
    }

    public static boolean isOPPO() {
        return PermissionPageManager.getManufacturer().equalsIgnoreCase(MANUFACTURER_OPPO);
    }

    public static boolean isMEIZU() {
        return PermissionPageManager.getManufacturer().equalsIgnoreCase(MANUFACTURER_MEIZU);
    }
}

