/*
 * Decompiled with CFR 0.152.
 */
package com.excellence.permission.apply;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.provider.CalendarContract;
import android.provider.CallLog;
import android.provider.ContactsContract;
import android.provider.Telephony;
import android.support.annotation.NonNull;
import android.support.v4.app.AppOpsManagerCompat;
import android.support.v4.content.ContextCompat;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.excellence.permission.apply.AudioRecordManager;
import com.excellence.permission.support.ManufacturerSupport;
import com.excellence.permission.support.PermissionPageManager;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class PermissionsChecker {
    private static final String TAG = PermissionsChecker.class.getSimpleName();
    private static final String TAG_NUMBER = "1";
    private static boolean isGranted = false;

    public static boolean isPermissionGranted(Context context, @NonNull String permission2) {
        try {
            switch (permission2) {
                case "android.permission.READ_CONTACTS": {
                    return PermissionsChecker.checkReadContacts(context);
                }
                case "android.permission.WRITE_CONTACTS": {
                    return PermissionsChecker.checkWriteContacts(context);
                }
                case "android.permission.READ_CALL_LOG": {
                    return PermissionsChecker.checkReadCallLog(context);
                }
                case "android.permission.READ_PHONE_STATE": {
                    return PermissionsChecker.checkReadPhoneState(context);
                }
                case "android.permission.WRITE_CALL_LOG": {
                    return PermissionsChecker.checkWriteCallLog(context);
                }
                case "android.permission.READ_CALENDAR": {
                    return PermissionsChecker.checkReadCalendar(context);
                }
                case "android.permission.BODY_SENSORS": {
                    return PermissionsChecker.checkBodySensors(context);
                }
                case "android.permission.ACCESS_COARSE_LOCATION": 
                case "android.permission.ACCESS_FINE_LOCATION": {
                    return PermissionsChecker.checkLocation(context);
                }
                case "android.permission.READ_EXTERNAL_STORAGE": {
                    return PermissionsChecker.checkReadStorage(context);
                }
                case "android.permission.WRITE_EXTERNAL_STORAGE": {
                    return PermissionsChecker.checkWriteStorage(context);
                }
                case "android.permission.RECORD_AUDIO": {
                    return PermissionsChecker.checkRecordAudio(context);
                }
                case "android.permission.READ_SMS": {
                    return PermissionsChecker.checkReadSms(context);
                }
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private static boolean checkReadSms(Context context) throws Exception {
        Cursor cursor = null;
        if (Build.VERSION.SDK_INT >= 19) {
            cursor = context.getContentResolver().query(Telephony.Sms.CONTENT_URI, null, null, null, null);
        }
        if (cursor != null) {
            if (ManufacturerSupport.isForceManufacturer() && PermissionsChecker.isNumberIndexInfoIsNull(cursor, cursor.getColumnIndex("date"))) {
                cursor.close();
                return false;
            }
            cursor.close();
            return true;
        }
        return false;
    }

    private static boolean checkRecordAudio(Context context) throws Exception {
        AudioRecordManager recordManager = new AudioRecordManager();
        recordManager.startRecord(new File(context.getExternalFilesDir(Environment.DIRECTORY_RINGTONES), TAG + ".3gp").getPath());
        recordManager.stopRecord();
        return recordManager.getSuccess();
    }

    private static boolean checkWriteStorage(Context context) throws Exception {
        File file = new File(Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES).getPath(), TAG);
        if (!file.exists()) {
            try {
                return file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        return file.delete();
    }

    private static boolean checkReadStorage(Context context) throws Exception {
        File file = new File(Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES).getPath());
        File[] files = file.listFiles();
        return files != null;
    }

    @SuppressLint(value={"MissingPermission"})
    private static boolean checkLocation(Context context) throws Exception {
        final LocationManager locationManager = (LocationManager)context.getSystemService("location");
        List providerList = locationManager.getProviders(true);
        if (providerList.contains("gps")) {
            return true;
        }
        if (providerList.contains("network")) {
            return true;
        }
        isGranted = false;
        if (!locationManager.isProviderEnabled("gps")) {
            locationManager.requestLocationUpdates("gps", 0L, 0.0f, new LocationListener(){

                public void onLocationChanged(Location location) {
                    locationManager.removeUpdates((LocationListener)this);
                }

                public void onStatusChanged(String provider, int status, Bundle extras) {
                    locationManager.removeUpdates((LocationListener)this);
                    isGranted = true;
                }

                public void onProviderEnabled(String provider) {
                    locationManager.removeUpdates((LocationListener)this);
                }

                public void onProviderDisabled(String provider) {
                    locationManager.removeUpdates((LocationListener)this);
                }
            });
        }
        return isGranted;
    }

    private static boolean checkBodySensors(Context context) throws Exception {
        SensorManager sensorManager = (SensorManager)context.getSystemService("sensor");
        Sensor sensor = sensorManager.getDefaultSensor(1);
        SensorEventListener listener = new SensorEventListener(){

            public void onSensorChanged(SensorEvent event) {
            }

            public void onAccuracyChanged(Sensor sensor, int accuracy) {
            }
        };
        sensorManager.registerListener(listener, sensor, 1);
        sensorManager.unregisterListener(listener, sensor);
        return true;
    }

    @SuppressLint(value={"MissingPermission"})
    private static boolean checkReadCalendar(Context context) throws Exception {
        Cursor cursor = context.getContentResolver().query(CalendarContract.Calendars.CONTENT_URI, null, null, null, null);
        if (cursor != null) {
            cursor.close();
            return true;
        }
        return false;
    }

    @SuppressLint(value={"MissingPermission"})
    private static boolean checkWriteCallLog(Context context) throws Exception {
        ContentResolver contentResolver = context.getContentResolver();
        ContentValues values = new ContentValues();
        values.put("type", Integer.valueOf(1));
        values.put("number", TAG_NUMBER);
        values.put("date", Integer.valueOf(20180101));
        values.put("new", "0");
        contentResolver.insert(CallLog.Calls.CONTENT_URI, values);
        contentResolver.delete(CallLog.Calls.CONTENT_URI, "number = ?", new String[]{TAG_NUMBER});
        return true;
    }

    @SuppressLint(value={"MissingPermission"})
    private static boolean checkReadPhoneState(Context context) throws Exception {
        TelephonyManager service = (TelephonyManager)context.getSystemService("phone");
        if (PermissionPageManager.isMEIZU()) {
            return !TextUtils.isEmpty((CharSequence)service.getSubscriberId());
        }
        if (PermissionPageManager.isXIAOMO() || PermissionPageManager.isOPPO()) {
            return !TextUtils.isEmpty((CharSequence)service.getDeviceId());
        }
        return !TextUtils.isEmpty((CharSequence)service.getDeviceId()) || !TextUtils.isEmpty((CharSequence)service.getSubscriberId());
    }

    @SuppressLint(value={"MissingPermission"})
    private static boolean checkReadCallLog(Context context) throws Exception {
        Cursor cursor = context.getContentResolver().query(CallLog.Calls.CONTENT_URI, null, null, null, null);
        if (cursor != null) {
            if (ManufacturerSupport.isForceManufacturer() && PermissionsChecker.isNumberIndexInfoIsNull(cursor, cursor.getColumnIndex("number"))) {
                cursor.close();
                return false;
            }
            cursor.close();
            return true;
        }
        return false;
    }

    private static boolean checkWriteContacts(Context context) throws Exception {
        if (PermissionsChecker.checkReadContacts(context)) {
            ContentValues values = new ContentValues();
            ContentResolver addResolver = context.getContentResolver();
            Uri rawContactUri = addResolver.insert(ContactsContract.RawContacts.CONTENT_URI, values);
            long rawContactId = ContentUris.parseId((Uri)rawContactUri);
            values.put("mimetype", "vnd.android.cursor.item/name");
            values.put("raw_contact_id", Long.valueOf(rawContactId));
            values.put("data2", TAG);
            values.put("data1", TAG_NUMBER);
            addResolver.insert(ContactsContract.Data.CONTENT_URI, values);
            Uri uri = ContactsContract.RawContacts.CONTENT_URI;
            ContentResolver deleteResolver = context.getContentResolver();
            Cursor cursor = deleteResolver.query(uri, new String[]{"_id"}, "display_name=?", new String[]{TAG}, null);
            if (cursor != null) {
                if (cursor.moveToFirst()) {
                    int id = cursor.getInt(0);
                    deleteResolver.delete(uri, "display_name=?", new String[]{TAG});
                    uri = ContactsContract.Data.CONTENT_URI;
                    deleteResolver.delete(uri, "raw_contact_id=?", new String[]{String.valueOf(id)});
                }
                cursor.close();
            }
            return true;
        }
        return false;
    }

    private static boolean checkReadContacts(Context context) throws Exception {
        Cursor cursor = context.getContentResolver().query(ContactsContract.CommonDataKinds.Phone.CONTENT_URI, null, null, null, null);
        if (cursor != null) {
            if (ManufacturerSupport.isForceManufacturer() && PermissionsChecker.isNumberIndexInfoIsNull(cursor, cursor.getColumnIndex("data1"))) {
                cursor.close();
                return false;
            }
            cursor.close();
            return true;
        }
        return false;
    }

    private static boolean isNumberIndexInfoIsNull(Cursor cursor, int columnIndex) {
        if (cursor.getCount() > 0) {
            if (cursor.moveToNext()) {
                return TextUtils.isEmpty((CharSequence)cursor.getString(columnIndex));
            }
            return false;
        }
        return true;
    }

    public static boolean hasPermission(@NonNull Context context, @NonNull String permission2) {
        if (ManufacturerSupport.isUnderMNeedChecked()) {
            return PermissionsChecker.isPermissionGranted(context, permission2);
        }
        if (Build.VERSION.SDK_INT >= 23) {
            if (ContextCompat.checkSelfPermission((Context)context, (String)permission2) == 0) {
                return PermissionsChecker.isPermissionGranted(context, permission2);
            }
            return false;
        }
        String op = AppOpsManagerCompat.permissionToOp((String)permission2);
        if (TextUtils.isEmpty((CharSequence)op)) {
            return true;
        }
        int result = AppOpsManagerCompat.noteProxyOp((Context)context, (String)op, (String)context.getPackageName());
        if (result == 1) {
            return false;
        }
        result = ContextCompat.checkSelfPermission((Context)context, (String)permission2);
        return result == 0;
    }

    public static boolean hasPermission(@NonNull Context context, @NonNull List<String> permissions) {
        for (String permission2 : permissions) {
            boolean isGranted = PermissionsChecker.hasPermission(context, permission2);
            if (isGranted) continue;
            return false;
        }
        return true;
    }

    public static boolean hasPermission(@NonNull Context context, String ... permissions) {
        return PermissionsChecker.hasPermission(context, Arrays.asList(permissions));
    }

    public static boolean hasAlwaysDeniedPermission(@NonNull Activity activity, @NonNull List<String> deniedPermissions) {
        for (String permission2 : deniedPermissions) {
            boolean rationale = false;
            if (Build.VERSION.SDK_INT >= 23) {
                rationale = activity.shouldShowRequestPermissionRationale(permission2);
            }
            if (rationale) continue;
            return true;
        }
        return false;
    }

    public static boolean hasAlwaysDeniedPermission(@NonNull Activity activity, String ... deniedPermissions) {
        return PermissionsChecker.hasAlwaysDeniedPermission(activity, Arrays.asList(deniedPermissions));
    }
}

