/*
 * Decompiled with CFR 0.152.
 */
package com.excellence.permission.apply;

import android.media.AudioRecord;
import android.os.Process;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class AudioRecordManager {
    public File file;
    private AudioRecord mRecorder;
    private DataOutputStream dos;
    private Thread recordThread;
    private boolean isStart = false;
    private int bufferSize;
    Runnable recordRunnable = new Runnable(){

        @Override
        public void run() {
            try {
                Process.setThreadPriority((int)-19);
                byte[] tempBuffer = new byte[AudioRecordManager.this.bufferSize];
                AudioRecordManager.this.mRecorder.startRecording();
                while (AudioRecordManager.this.isStart) {
                    int bytesRecord;
                    if (AudioRecordManager.this.mRecorder == null || (bytesRecord = AudioRecordManager.this.mRecorder.read(tempBuffer, 0, AudioRecordManager.this.bufferSize)) == -3 || bytesRecord == -2) continue;
                    if (bytesRecord != 0 && bytesRecord != -1) {
                        AudioRecordManager.this.dos.write(tempBuffer, 0, bytesRecord);
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };
    private long length;

    public AudioRecordManager() {
        this.bufferSize = AudioRecord.getMinBufferSize((int)8000, (int)16, (int)2);
        this.mRecorder = new AudioRecord(1, 8000, 16, 2, this.bufferSize * 2);
    }

    public boolean getSuccess() {
        return this.length > 0L;
    }

    private void destroyThread() {
        try {
            this.isStart = false;
            if (this.recordThread != null && this.recordThread.getState() != Thread.State.TERMINATED) {
                try {
                    this.recordThread.interrupt();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.recordThread = null;
                }
            }
            this.recordThread = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.recordThread = null;
        }
    }

    private void startThread() {
        this.isStart = true;
        if (this.recordThread == null) {
            this.recordThread = new Thread(this.recordRunnable);
            this.recordThread.start();
        }
    }

    private void setPath(String path) throws IOException {
        this.file = new File(path);
        this.deleteFile();
        this.file.createNewFile();
        this.dos = new DataOutputStream(new FileOutputStream(this.file, true));
    }

    public void startRecord(String path) throws IOException, InterruptedException {
        this.setPath(path);
        this.startThread();
    }

    public void stopRecord() throws IOException, InterruptedException {
        Thread.sleep(250L);
        this.destroyThread();
        if (this.mRecorder != null) {
            if (this.mRecorder.getState() == 1) {
                this.mRecorder.stop();
            }
            if (this.mRecorder != null) {
                this.mRecorder.release();
            }
        }
        if (this.dos != null) {
            this.dos.flush();
            this.dos.close();
        }
        this.length = this.file.length();
        this.deleteFile();
    }

    private void deleteFile() {
        if (this.file.exists()) {
            this.file.delete();
        }
    }
}

