/*
 * Decompiled with CFR 0.152.
 */
package com.excellence.permission;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.excellence.permission.IPermissionListener;
import com.excellence.permission.IRationaleListener;
import com.excellence.permission.SettingDialog;
import com.excellence.permission.apply.PermissionsChecker;
import java.util.ArrayList;
import java.util.List;

public final class PermissionActivity
extends Activity {
    public static final String TAG = PermissionActivity.class.getSimpleName();
    public static final String KEY_PERMISSIONS = "KEY_PERMISSIONS";
    private static OnRationaleListener mOnRationaleListener = null;
    private static IPermissionListener mRequestPermissionsListener = null;
    private static IRationaleListener mRequestRationaleListener = null;
    private List<String> mDeniedPermissions = new ArrayList<String>();

    protected static void setOnRationaleListener(OnRationaleListener listener) {
        mOnRationaleListener = listener;
    }

    protected static void setRequestPermissionsListener(IPermissionListener listener) {
        mRequestPermissionsListener = listener;
    }

    protected static void setRequestRationaleListener(IRationaleListener listener) {
        mRequestRationaleListener = listener;
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Intent intent = this.getIntent();
        ArrayList permissions = intent.getStringArrayListExtra(KEY_PERMISSIONS);
        if (permissions == null || permissions.size() == 0) {
            mOnRationaleListener = null;
            mRequestPermissionsListener = null;
            this.finish();
            return;
        }
        if (mOnRationaleListener != null) {
            boolean rationale = false;
            for (String permission2 : permissions) {
                if (Build.VERSION.SDK_INT >= 23) {
                    rationale = this.shouldShowRequestPermissionRationale(permission2);
                }
                if (!rationale) continue;
                break;
            }
            mOnRationaleListener.onRationaleResult(rationale);
            mOnRationaleListener = null;
            this.finish();
            return;
        }
        if (mRequestPermissionsListener != null) {
            if (Build.VERSION.SDK_INT >= 23) {
                this.requestPermissions(permissions.toArray(new String[permissions.size()]), 1);
            } else {
                this.onRequestPermissionsResult(permissions.toArray(new String[permissions.size()]));
            }
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        this.onRequestPermissionsResult(permissions);
    }

    private void onRequestPermissionsResult(String[] permissions) {
        if (mRequestPermissionsListener != null) {
            for (int i = 0; i < permissions.length; ++i) {
                if (PermissionsChecker.hasPermission((Context)this, permissions[i])) continue;
                this.mDeniedPermissions.add(permissions[i]);
            }
            if (this.mDeniedPermissions.isEmpty()) {
                this.permissionsGranted();
            } else if (PermissionsChecker.hasAlwaysDeniedPermission((Activity)this, this.mDeniedPermissions)) {
                if (mRequestRationaleListener != null) {
                    mRequestRationaleListener.onRationale(this);
                } else {
                    new SettingDialog((Context)this).setOnCancelListener(new SettingDialog.OnCancelListener(){

                        @Override
                        public void onCancel() {
                            PermissionActivity.this.permissionsDenied();
                        }
                    }).show();
                }
            } else {
                this.permissionsDenied();
            }
        }
    }

    public void permissionsGranted() {
        if (mRequestPermissionsListener != null) {
            mRequestPermissionsListener.onPermissionsGranted();
        }
        mRequestPermissionsListener = null;
        mRequestRationaleListener = null;
        this.finish();
    }

    public void permissionsDenied() {
        if (mRequestPermissionsListener != null) {
            mRequestPermissionsListener.onPermissionsDenied();
        }
        mRequestPermissionsListener = null;
        mRequestRationaleListener = null;
        this.finish();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 1024) {
            if (PermissionsChecker.hasPermission((Context)this, this.mDeniedPermissions)) {
                this.permissionsGranted();
            } else {
                this.permissionsDenied();
            }
        }
    }

    protected static interface OnRationaleListener {
        public void onRationaleResult(boolean var1);
    }
}

