/*
 * Decompiled with CFR 0.152.
 */
package com.excellence.permission;

import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.annotation.Size;
import com.excellence.permission.IPermissionListener;
import com.excellence.permission.IRationaleListener;
import com.excellence.permission.PermissionActivity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PermissionRequest {
    public static final String TAG = PermissionRequest.class.getSimpleName();
    private Context mContext = null;
    private IPermissionListener mPermissionListener = null;
    private IRationaleListener mRationaleListener = null;
    private List<String> mRequestPermissions = null;
    private Handler mHandler = new Handler();

    @NonNull
    public static PermissionRequest with(Context context) {
        return new PermissionRequest(context);
    }

    public PermissionRequest(Context context) {
        this.mContext = context;
        this.mRequestPermissions = new ArrayList<String>();
    }

    public PermissionRequest permission(@Size(min=1L) List<String> permissions) {
        this.mRequestPermissions.addAll(permissions);
        return this;
    }

    public PermissionRequest permission(String ... permissions) {
        return this.permission(Arrays.asList(permissions));
    }

    public PermissionRequest rationale(IRationaleListener listener) {
        this.mRationaleListener = listener;
        return this;
    }

    public void request(IPermissionListener listener) {
        this.mPermissionListener = new RequestListener(listener);
        if (this.mRequestPermissions.size() > 0) {
            PermissionActivity.setOnRationaleListener(new RationaleListener());
            this.startPermissionActivity();
        } else {
            this.mPermissionListener.onPermissionsGranted();
        }
    }

    public void resume() {
        PermissionActivity.setRequestPermissionsListener(this.mPermissionListener);
        PermissionActivity.setRequestRationaleListener(this.mRationaleListener);
        this.startPermissionActivity();
    }

    private void startPermissionActivity() {
        Intent intent = new Intent(this.mContext, PermissionActivity.class);
        intent.putStringArrayListExtra("KEY_PERMISSIONS", (ArrayList)this.mRequestPermissions);
        intent.setFlags(0x10000000);
        this.mContext.startActivity(intent);
    }

    private class RationaleListener
    implements PermissionActivity.OnRationaleListener {
        private RationaleListener() {
        }

        @Override
        public void onRationaleResult(boolean showRationale) {
            PermissionRequest.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    PermissionRequest.this.resume();
                }
            });
        }
    }

    private class RequestListener
    implements IPermissionListener {
        private IPermissionListener mListener = null;

        public RequestListener(IPermissionListener listener) {
            this.mListener = listener;
        }

        @Override
        public void onPermissionsGranted() {
            if (this.mListener != null) {
                this.mListener.onPermissionsGranted();
            }
        }

        @Override
        public void onPermissionsDenied() {
            if (this.mListener != null) {
                this.mListener.onPermissionsDenied();
            }
        }
    }
}

