/*
 * Decompiled with CFR 0.152.
 */
package com.excellence.permission;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.support.annotation.Size;
import android.support.v4.app.AppOpsManagerCompat;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import com.excellence.permission.IPermissionListener;
import com.excellence.permission.IRationaleListener;
import com.excellence.permission.PermissionActivity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PermissionRequest {
    public static final String TAG = PermissionRequest.class.getSimpleName();
    private Context mContext = null;
    private IPermissionListener mPermissionListener = null;
    private IRationaleListener mRationaleListener = null;
    private List<String> mRequestPermissions = null;
    private List<String> mDeniedPermissions = null;

    @NonNull
    public static PermissionRequest with(Context context) {
        return new PermissionRequest(context);
    }

    public PermissionRequest(Context context) {
        this.mContext = context;
        this.mRequestPermissions = new ArrayList<String>();
    }

    public PermissionRequest permission(@Size(min=1L) List<String> permissions) {
        this.mRequestPermissions.addAll(permissions);
        return this;
    }

    public PermissionRequest permission(String ... permissions) {
        return this.permission(Arrays.asList(permissions));
    }

    public PermissionRequest rationale(IRationaleListener listener) {
        this.mRationaleListener = listener;
        return this;
    }

    public void request(IPermissionListener listener) {
        this.mPermissionListener = new RequestListener(listener);
        if (Build.VERSION.SDK_INT < 23) {
            this.mPermissionListener.onPermissionsGranted();
        } else {
            this.mDeniedPermissions = PermissionRequest.getDeniedPermissions(this.mContext, this.mRequestPermissions);
            if (this.mDeniedPermissions.size() > 0) {
                PermissionActivity.setOnRationaleListener(new RationaleListener());
                this.startPermissionActivity();
            } else {
                this.mPermissionListener.onPermissionsGranted();
            }
        }
    }

    @RequiresApi(api=23)
    public void resume() {
        PermissionActivity.setRequestPermissionsListener(this.mPermissionListener);
        PermissionActivity.setRequestRationaleListener(this.mRationaleListener);
        this.startPermissionActivity();
    }

    private void startPermissionActivity() {
        Intent intent = new Intent(this.mContext, PermissionActivity.class);
        intent.putStringArrayListExtra("KEY_PERMISSIONS", (ArrayList)this.mDeniedPermissions);
        intent.setFlags(0x10000000);
        this.mContext.startActivity(intent);
    }

    public static List<String> getDeniedPermissions(@NonNull Context context, @NonNull List<String> permissions) {
        ArrayList<String> deniedPermissions = new ArrayList<String>();
        for (String permission : permissions) {
            if (ContextCompat.checkSelfPermission((Context)context, (String)permission) == 0) continue;
            deniedPermissions.add(permission);
        }
        return deniedPermissions;
    }

    public static boolean hasPermission(@NonNull Context context, @NonNull List<String> permissions) {
        if (Build.VERSION.SDK_INT < 23) {
            return true;
        }
        for (String permission : permissions) {
            String op = AppOpsManagerCompat.permissionToOp((String)permission);
            if (TextUtils.isEmpty((CharSequence)op)) continue;
            int result = AppOpsManagerCompat.noteProxyOp((Context)context, (String)op, (String)context.getPackageName());
            if (result == 1) {
                return false;
            }
            result = ContextCompat.checkSelfPermission((Context)context, (String)permission);
            if (result == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean hasPermission(@NonNull Context context, String ... permissions) {
        return PermissionRequest.hasPermission(context, Arrays.asList(permissions));
    }

    public static boolean hasAlwaysDeniedPermission(@NonNull Activity activity, @NonNull List<String> deniedPermissions) {
        if (Build.VERSION.SDK_INT < 23) {
            return false;
        }
        for (String permission : deniedPermissions) {
            boolean rationale = activity.shouldShowRequestPermissionRationale(permission);
            if (rationale) continue;
            return true;
        }
        return false;
    }

    public static boolean hasAlwaysDeniedPermission(@NonNull Activity activity, String ... deniedPermissions) {
        return PermissionRequest.hasAlwaysDeniedPermission(activity, Arrays.asList(deniedPermissions));
    }

    private class RationaleListener
    implements PermissionActivity.OnRationaleListener {
        private RationaleListener() {
        }

        @Override
        @RequiresApi(api=23)
        public void onRationaleResult(boolean showRationale) {
            PermissionRequest.this.resume();
        }
    }

    private class RequestListener
    implements IPermissionListener {
        private IPermissionListener mListener = null;

        public RequestListener(IPermissionListener listener) {
            this.mListener = listener;
        }

        @Override
        public void onPermissionsGranted() {
            if (this.mListener != null) {
                this.mListener.onPermissionsGranted();
            }
        }

        @Override
        public void onPermissionsDenied() {
            if (this.mListener != null) {
                this.mListener.onPermissionsDenied();
            }
        }
    }
}

