/*
 * Decompiled with CFR 0.152.
 */
package com.excellence.permission;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import com.excellence.permission.IPermissionListener;
import com.excellence.permission.IRationaleListener;
import com.excellence.permission.PermissionRequest;
import com.excellence.permission.SettingDialog;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class PermissionActivity
extends Activity {
    public static final String TAG = PermissionActivity.class.getSimpleName();
    public static final String KEY_PERMISSIONS = "KEY_PERMISSIONS";
    private static OnRationaleListener mOnRationaleListener = null;
    private static IPermissionListener mRequestPermissionsListener = null;
    private static IRationaleListener mRequestRationaleListener = null;
    private List<String> mDeniedPermissions = new ArrayList<String>();

    protected static void setOnRationaleListener(OnRationaleListener listener) {
        mOnRationaleListener = listener;
    }

    protected static void setRequestPermissionsListener(IPermissionListener listener) {
        mRequestPermissionsListener = listener;
    }

    protected static void setRequestRationaleListener(IRationaleListener listener) {
        mRequestRationaleListener = listener;
    }

    @RequiresApi(api=23)
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Intent intent = this.getIntent();
        ArrayList permissions = intent.getStringArrayListExtra(KEY_PERMISSIONS);
        if (permissions == null || permissions.size() == 0) {
            mOnRationaleListener = null;
            mRequestPermissionsListener = null;
            this.finish();
            return;
        }
        if (mOnRationaleListener != null) {
            String permission;
            boolean rationale = false;
            Iterator iterator = permissions.iterator();
            while (iterator.hasNext() && !(rationale = this.shouldShowRequestPermissionRationale(permission = (String)iterator.next()))) {
            }
            mOnRationaleListener.onRationaleResult(rationale);
            mOnRationaleListener = null;
            this.finish();
            return;
        }
        if (mRequestPermissionsListener != null) {
            this.requestPermissions(permissions.toArray(new String[permissions.size()]), 1);
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (mRequestPermissionsListener != null) {
            for (int i = 0; i < permissions.length; ++i) {
                if (grantResults[i] == 0) continue;
                this.mDeniedPermissions.add(permissions[i]);
            }
            if (this.mDeniedPermissions.isEmpty()) {
                this.permissionsGranted();
            } else if (PermissionRequest.hasAlwaysDeniedPermission((Activity)this, this.mDeniedPermissions)) {
                if (mRequestRationaleListener != null) {
                    mRequestRationaleListener.OnRationale(this);
                } else {
                    new SettingDialog((Context)this).setOnCancelListener(new SettingDialog.OnCancelListener(){

                        @Override
                        public void onCancel() {
                            PermissionActivity.this.permissionsDenied();
                        }
                    }).show();
                }
            } else {
                this.permissionsDenied();
            }
        }
    }

    public void permissionsGranted() {
        mRequestPermissionsListener.onPermissionsGranted();
        mRequestPermissionsListener = null;
        mRequestRationaleListener = null;
        this.finish();
    }

    public void permissionsDenied() {
        mRequestPermissionsListener.onPermissionsDenied();
        mRequestPermissionsListener = null;
        mRequestRationaleListener = null;
        this.finish();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 1024) {
            if (PermissionRequest.hasPermission((Context)this, this.mDeniedPermissions)) {
                this.permissionsGranted();
            } else {
                this.permissionsDenied();
            }
        }
    }

    protected static interface OnRationaleListener {
        public void onRationaleResult(boolean var1);
    }
}

