/*
 * Copyright (C) 2017 - present by PyXLL Ltd.
 */
package com.exceljava.jinx;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * ExcelMenu annotation for methods that should be
 * exposed as Excel menu items.
 */
@Target(ElementType.METHOD)
@Retention(RetentionPolicy.RUNTIME)
public @interface ExcelMenu {

    /**
     * Name of the menu item as it will appear in Excel.
     */
    String value();

    /**
     * Name of the menu the item will appear under.
     */
    String menu() default "";

    /**
     * Name of the sub-menu the item will appear under.
     */
    String subMenu() default "";

    /**
     * Influences where the item appears in the menu.
     *
     * Negative numbers are used to position items from the bottom
     * of the list, with -1 being the last element and -2 being the
     * penultimate element etc.
     *
     * Items with the same sort order are ordered lexicographically.
     *
     * If the item is a sub-menu item, this order influences where the
     * sub-menu will appear in the main menu.
     */
    int order() default Integer.MAX_VALUE;

    /*
     * Similar to order but it is used to set the order of items within
     * a sub-menu.
     */
    int subOrder() default Integer.MAX_VALUE;

    /*
     * Used when there are multiple menus and controls the order in which
     * the menus are added.
     */
    int menuOrder() default Integer.MAX_VALUE;

    /*
     * Assigns a keyboard shortcut to the menu item.
     *
     * Shortcuts should be one or more modifier key names (Ctrl, Shift or Alt)
     * and a key, separated by the '+' symbol. For example, 'Ctrl+Shift+R'.
     */
    String shortcut() default "";
}
