/*
 * Copyright (C) 2017 - present by PyXLL Ltd.
 */
package com.exceljava.jinx;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

/**
 * ExcelArguments annotation for arguments of methods
 * exposed as Excel worksheet functions via {@link ExcelFunction}.
 *
 * @see ExcelArgument
 */
@Retention(RetentionPolicy.RUNTIME)
public @interface ExcelArguments {

    /**
     * The argument annotations in the same order as
     * the method parameters.
     */
    ExcelArgument[] value();
}
