/*
 * Decompiled with CFR 0.152.
 */
package com.exblr.rangeseekbar;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import com.exblr.rangeseekbar.R;

public class RangeSeekBar
extends View {
    private int mThumbSize;
    private float[] mScales;
    private int mScaleTextSize;
    private int mScaleTextPaddingTop;
    private int mScaleTextColor;
    private int mLineColorNormal;
    private int mLineColorSelection;
    private float mLimitMin;
    private float mLimitMax;
    private float mMin;
    private float mMax;
    private float lastX;
    private int minX;
    private int maxX;
    private int startX;
    private int endX;
    private int lineY;
    private boolean isMinPressed;
    private boolean isMaxPressed;
    private Rect startRect;
    private Rect endRect;
    private Paint linePaint;
    private Paint scaleTextPaint;
    private Bitmap thumbBitmap;
    private OnScaleTextFormat mOnScaleTextFormat;
    private OnRangeChanged mOnRangeChanged;

    public RangeSeekBar(Context context) {
        this(context, null);
    }

    public RangeSeekBar(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public RangeSeekBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mThumbSize = RangeSeekBar.dpToPx(context, 40);
        this.mScaleTextSize = RangeSeekBar.spToPx(context, 13);
        this.mScaleTextColor = -8947849;
        this.mScaleTextPaddingTop = RangeSeekBar.dpToPx(context, 10);
        this.mLineColorNormal = -3355444;
        this.mLineColorSelection = -241380;
        this.linePaint = new Paint(1);
        this.linePaint.setStrokeWidth(10.0f);
        this.scaleTextPaint = new Paint(1);
        this.scaleTextPaint.setColor(this.mScaleTextColor);
        this.scaleTextPaint.setTextSize((float)this.mScaleTextSize);
        this.thumbBitmap = BitmapFactory.decodeResource((Resources)this.getResources(), (int)R.drawable.ic_seek_thumb_normal);
    }

    public void setOnScaleTextFormat(OnScaleTextFormat onScaleTextFormat) {
        this.mOnScaleTextFormat = onScaleTextFormat;
    }

    public void setOnRangeChanged(OnRangeChanged onRangeChanged) {
        this.mOnRangeChanged = onRangeChanged;
    }

    public void setThumbSize(int thumbSize) {
        this.mThumbSize = thumbSize;
    }

    public void setScales(float[] scales) {
        this.mScales = scales;
        this.mLimitMin = scales[0];
        this.mLimitMax = scales[scales.length - 1];
        this.mMin = this.mLimitMin;
        this.mMax = this.mLimitMax;
    }

    public void setScaleTextPaddingTop(int scaleTextPaddingTop) {
        this.mScaleTextPaddingTop = scaleTextPaddingTop;
    }

    public void setScaleTextSize(int scaleTextSize) {
        this.mScaleTextSize = scaleTextSize;
    }

    public void setScaleTextColor(int scaleTextColor) {
        this.mScaleTextColor = scaleTextColor;
    }

    public void setLineColorNormal(int lineColorNormal) {
        this.mLineColorNormal = lineColorNormal;
    }

    public void setLineColorSelection(int lineColorSelection) {
        this.mLineColorSelection = lineColorSelection;
    }

    public float[] getScales() {
        return this.mScales;
    }

    public float getMax() {
        return this.mMax;
    }

    public float getMin() {
        return this.mMin;
    }

    public float getLimitMax() {
        return this.mLimitMax;
    }

    public float getLimitMin() {
        return this.mLimitMin;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.mScales == null || this.mScales.length < 2) {
            throw new IllegalArgumentException("\u9700\u8981\u5148\u8c03\u7528 setScales \u65b9\u6cd5\u8bbe\u7f6e\u523b\u5ea6\uff0c\u5176\u6570\u91cf\u4e0d\u80fd\u5c11\u4e8e2");
        }
        this.startX = this.getPaddingLeft() + this.mThumbSize / 2;
        this.endX = this.getWidth() - this.getPaddingRight() - this.mThumbSize / 2;
        this.minX = this.startX;
        this.maxX = this.endX;
        this.lineY = this.getPaddingTop() + this.mThumbSize / 2;
        this.startRect = new Rect(this.startX - this.mThumbSize / 2, 0, this.startX + this.mThumbSize / 2, this.mThumbSize);
        this.endRect = new Rect(this.endX - this.mThumbSize / 2, 0, this.endX + this.mThumbSize / 2, this.mThumbSize);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        if (heightMode == Integer.MIN_VALUE) {
            int viewHeight = this.getPaddingTop() + this.mThumbSize + this.mScaleTextPaddingTop + this.mScaleTextSize + this.getPaddingBottom();
            heightSize = Math.min(viewHeight, heightSize);
        }
        this.setMeasuredDimension(View.MeasureSpec.getSize((int)widthMeasureSpec), heightSize);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.linePaint.setColor(this.mLineColorNormal);
        canvas.drawLine((float)this.minX, (float)this.lineY, (float)this.maxX, (float)this.lineY, this.linePaint);
        this.linePaint.setColor(this.mLineColorSelection);
        canvas.drawLine((float)this.startX, (float)this.lineY, (float)this.endX, (float)this.lineY, this.linePaint);
        this.startRect.set(this.startX - this.mThumbSize / 2, 0, this.startX + this.mThumbSize / 2, this.mThumbSize);
        this.endRect.set(this.endX - this.mThumbSize / 2, 0, this.endX + this.mThumbSize / 2, this.mThumbSize);
        canvas.drawBitmap(this.thumbBitmap, null, this.startRect, null);
        canvas.drawBitmap(this.thumbBitmap, null, this.endRect, null);
        for (int i = 0; i < this.mScales.length; ++i) {
            String text = this.mOnScaleTextFormat == null ? this.mScales[i] + "" : this.mOnScaleTextFormat.format(this.mScales[i], i);
            float x = (float)this.minX + (float)(this.maxX - this.minX) * (this.mScales[i] - this.mLimitMin) / (this.mLimitMax - this.mLimitMin) - this.scaleTextPaint.measureText(text) / 2.0f;
            float y = this.startRect.bottom + this.mScaleTextPaddingTop;
            canvas.drawText(text, x, y, this.scaleTextPaint);
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                float x = event.getX();
                float y = event.getY();
                if (x > (float)this.startRect.left && x < (float)this.startRect.right && y > (float)this.startRect.top && y < (float)this.startRect.bottom && !this.isMaxPressed) {
                    this.isMinPressed = true;
                }
                if (x > (float)this.endRect.left && x < (float)this.endRect.right && y > (float)this.endRect.top && y < (float)this.endRect.bottom && !this.isMinPressed) {
                    this.isMaxPressed = true;
                }
                this.lastX = event.getX();
                return true;
            }
            case 2: {
                float offsetX = event.getX() - this.lastX;
                if (this.isMinPressed) {
                    this.startX = (int)((float)this.startX + offsetX);
                    if (this.startX < this.minX) {
                        this.startX = this.minX;
                    }
                    if (this.startX > this.maxX) {
                        this.startX = this.maxX;
                    }
                    this.mMin = this.mLimitMin + (this.mLimitMax - this.mLimitMin) * (float)(this.startX - this.minX) / (float)(this.maxX - this.minX);
                    this.invalidate();
                }
                if (this.isMaxPressed) {
                    this.endX = (int)((float)this.endX + offsetX);
                    if (this.endX > this.maxX) {
                        this.endX = this.maxX;
                    }
                    if (this.endX < this.minX) {
                        this.endX = this.minX;
                    }
                    this.mMax = this.mLimitMin + (this.mLimitMax - this.mLimitMin) * (float)(this.endX - this.minX) / (float)(this.maxX - this.minX);
                    this.invalidate();
                }
                this.lastX = event.getX();
                break;
            }
            case 1: 
            case 3: {
                this.isMinPressed = false;
                this.isMaxPressed = false;
            }
        }
        if (this.isMaxPressed || this.isMinPressed) {
            this.getParent().requestDisallowInterceptTouchEvent(true);
            if (this.mOnRangeChanged != null) {
                this.mOnRangeChanged.onChange(Math.min(this.mMin, this.mMax), Math.max(this.mMin, this.mMax));
            }
        }
        return super.onTouchEvent(event);
    }

    public static int dpToPx(Context context, int dp) {
        return (int)(TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)context.getResources().getDisplayMetrics()) + 0.5f);
    }

    public static int spToPx(Context context, int sp) {
        return (int)(TypedValue.applyDimension((int)2, (float)sp, (DisplayMetrics)context.getResources().getDisplayMetrics()) + 0.5f);
    }

    public static interface OnRangeChanged {
        public void onChange(float var1, float var2);
    }

    public static interface OnScaleTextFormat {
        public String format(float var1, int var2);
    }
}

