/*
 * Decompiled with CFR 0.152.
 */
package com.exblr.dropdownmenu;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.PopupWindow;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.exblr.dropdownmenu.DropdownListAdapter;
import com.exblr.dropdownmenu.DropdownListItem;
import com.exblr.dropdownmenu.R;
import java.util.ArrayList;
import java.util.List;

public class DropdownMenu
extends LinearLayout {
    private int mTabTextSize;
    private int mTabTextColorNormal;
    private int mTabTextColorSelected;
    private int mDividerColor;
    private int mDividerPadding;
    private int mBorderColor;
    private int mTabIconNormal;
    private int mTabIconSelected;
    private Context mContext;
    private int mCurrentTabIndex;
    private List<OnMenuOpenListener> mOnMenuOpenListeners;
    private PopupWindow mCurrentPopupWindow;

    public DropdownMenu(Context context) {
        this(context, null);
    }

    public DropdownMenu(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public DropdownMenu(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setOrientation(0);
        this.setWillNotDraw(false);
        this.mContext = context;
        this.mDividerPadding = DropdownMenu.dpToPx(this.mContext, this.mDividerPadding);
        this.mOnMenuOpenListeners = new ArrayList<OnMenuOpenListener>();
        TypedArray t = context.obtainStyledAttributes(attrs, R.styleable.DropdownMenu);
        this.mTabTextSize = t.getDimensionPixelSize(R.styleable.DropdownMenu_ddmTabTextSize, 13);
        this.mTabTextColorNormal = t.getColor(R.styleable.DropdownMenu_ddmTabTextColorNormal, -10066330);
        this.mTabTextColorSelected = t.getColor(R.styleable.DropdownMenu_ddmTabTextColorSelected, -16740878);
        this.mDividerColor = t.getColor(R.styleable.DropdownMenu_ddmDividerColor, -2236963);
        this.mDividerPadding = t.getDimensionPixelSize(R.styleable.DropdownMenu_ddmDividerPadding, DropdownMenu.dpToPx(this.mContext, 13));
        this.mBorderColor = t.getColor(R.styleable.DropdownMenu_ddmBorderColor, -1118482);
        this.mTabIconNormal = t.getResourceId(R.styleable.DropdownMenu_ddmTabIconNormal, R.drawable.ic_arrow_down);
        this.mTabIconSelected = t.getResourceId(R.styleable.DropdownMenu_ddmTabIconSelected, R.drawable.ic_arrow_up);
        t.recycle();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int w = this.getWidth();
        int h = this.getHeight();
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        paint.setColor(this.mDividerColor);
        for (int i = 0; i < this.getChildCount() - 1; ++i) {
            View child = this.getChildAt(i);
            if (child == null || child.getVisibility() == 8) continue;
            canvas.drawLine((float)child.getRight(), (float)this.mDividerPadding, (float)child.getRight(), (float)(h - this.mDividerPadding), paint);
        }
        int lineHeight = 1;
        paint.setColor(this.mBorderColor);
        canvas.drawRect(0.0f, 0.0f, (float)w, (float)lineHeight, paint);
        canvas.drawRect(0.0f, (float)(h - lineHeight), (float)w, (float)h, paint);
    }

    public void add(String title, OnMenuOpenListener onMenuOpenListener) {
        this.addTab(title);
        this.mOnMenuOpenListeners.add(onMenuOpenListener);
    }

    public void add(String title, List<DropdownListItem> list) {
        ListView listView = new ListView(this.mContext);
        listView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        listView.setScrollBarStyle(0x2000000);
        final PopupWindow popupWindow = this.createPopupWindow(title, (View)listView);
        final DropdownListAdapter defaultAdapter = new DropdownListAdapter(this.mContext, title, list);
        listView.setAdapter((ListAdapter)defaultAdapter);
        listView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                defaultAdapter.setSelectedItem(position);
                DropdownMenu.this.setCurrentTitle(defaultAdapter.getSelectedItemString());
                popupWindow.dismiss();
            }
        });
    }

    public void add(String title, View contentView) {
        this.createPopupWindow(title, contentView);
    }

    public void notifyMenuClosed() {
        this.setTabNormal(this.mCurrentTabIndex, null);
    }

    public void dismissCurrentPopupWindow() {
        if (this.mCurrentPopupWindow != null) {
            this.mCurrentPopupWindow.dismiss();
        }
    }

    private PopupWindow createPopupWindow(String title, View contentView) {
        View popupWindowView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.popup_window, null, false);
        final PopupWindow popupWindow = new PopupWindow(popupWindowView, -1, -1, true);
        popupWindow.setOnDismissListener(new PopupWindow.OnDismissListener(){

            public void onDismiss() {
                DropdownMenu.this.notifyMenuClosed();
                DropdownMenu.this.mCurrentPopupWindow = null;
            }
        });
        FrameLayout contentContainer = (FrameLayout)popupWindowView.findViewById(R.id.popup_window_content_container);
        contentContainer.addView(contentView);
        View overlay = popupWindowView.findViewById(R.id.popup_window_overlay);
        overlay.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                popupWindow.dismiss();
            }
        });
        this.add(title, new OnMenuOpenListener(){

            @Override
            public void onOpen(View tabView, int tabIndex) {
                popupWindow.showAsDropDown((View)DropdownMenu.this);
                DropdownMenu.this.mCurrentPopupWindow = popupWindow;
            }
        });
        return popupWindow;
    }

    private View addTab(String title) {
        TextView titleTV = new TextView(this.mContext);
        titleTV.setGravity(17);
        titleTV.setText((CharSequence)title);
        titleTV.setTextSize(0, (float)this.mTabTextSize);
        titleTV.setTextColor(this.mTabTextColorNormal);
        titleTV.setSingleLine();
        titleTV.setEllipsize(TextUtils.TruncateAt.END);
        titleTV.setCompoundDrawablesWithIntrinsicBounds(null, null, this.getResources().getDrawable(this.mTabIconNormal), null);
        titleTV.setCompoundDrawablePadding(DropdownMenu.dpToPx(this.mContext, 5));
        RelativeLayout tabLayout = new RelativeLayout(this.mContext);
        RelativeLayout.LayoutParams titleParams = new RelativeLayout.LayoutParams(-2, -2);
        titleParams.addRule(13);
        tabLayout.addView((View)titleTV, (ViewGroup.LayoutParams)titleParams);
        tabLayout.setPaddingRelative(DropdownMenu.dpToPx(this.mContext, 5), 0, DropdownMenu.dpToPx(this.mContext, 5), 0);
        LinearLayout.LayoutParams tabParams = new LinearLayout.LayoutParams(-1, -1, 1.0f);
        tabParams.gravity = 17;
        tabLayout.setLayoutParams((ViewGroup.LayoutParams)tabParams);
        tabLayout.setOnClickListener((View.OnClickListener)new MyTabClickedListener(this.getChildCount()));
        this.addView((View)tabLayout);
        return tabLayout;
    }

    private TextView getTabTextViewAt(int index) {
        return (TextView)((ViewGroup)this.getChildAt(index)).getChildAt(0);
    }

    public void setCurrentTitle(String text) {
        this.setTabNormal(this.mCurrentTabIndex, text);
    }

    private void setTabNormal(int index, String title) {
        TextView tv = this.getTabTextViewAt(index);
        tv.setTextColor(this.mTabTextColorNormal);
        tv.setCompoundDrawablesWithIntrinsicBounds(null, null, this.getResources().getDrawable(this.mTabIconNormal), null);
        if (title != null && title != "") {
            tv.setText((CharSequence)title);
        }
    }

    private void setTabSelected(int index) {
        TextView tv = this.getTabTextViewAt(index);
        tv.setTextColor(this.mTabTextColorSelected);
        tv.setCompoundDrawablesWithIntrinsicBounds(null, null, this.getResources().getDrawable(this.mTabIconSelected), null);
    }

    public static int dpToPx(Context context, int dp) {
        return (int)(TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)context.getResources().getDisplayMetrics()) + 0.5f);
    }

    private class MyTabClickedListener
    implements View.OnClickListener {
        private int mIndex;

        public MyTabClickedListener(int index) {
            this.mIndex = index;
        }

        public void onClick(View view) {
            DropdownMenu.this.setTabNormal(DropdownMenu.this.mCurrentTabIndex, null);
            DropdownMenu.this.setTabSelected(this.mIndex);
            DropdownMenu.this.mCurrentTabIndex = this.mIndex;
            for (int i = 0; i < DropdownMenu.this.mOnMenuOpenListeners.size(); ++i) {
                if (i != DropdownMenu.this.mCurrentTabIndex) continue;
                ((OnMenuOpenListener)DropdownMenu.this.mOnMenuOpenListeners.get(i)).onOpen(view, i);
                break;
            }
        }
    }

    public static interface OnMenuOpenListener {
        public void onOpen(View var1, int var2);
    }
}

