/*
 * Decompiled with CFR 0.152.
 */
package com.exblr.dropdownmenu;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.PopupWindow;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.exblr.dropdownmenu.DropdownListAdapter;
import com.exblr.dropdownmenu.DropdownListItem;
import com.exblr.dropdownmenu.R;
import java.util.ArrayList;
import java.util.List;

public class DropdownMenu
extends LinearLayout {
    private int mCurrentTabIndex;
    private int mTabTextSize = 13;
    private int mTabNormalColor = -10066330;
    private int mTabSelectedColor = -16740878;
    private int mTabArrowLeftPadding = 5;
    private int mDividerColor = -2236963;
    private int mDividerPadding = 13;
    private int mLineHeight = 1;
    private int mLineColor = -1118482;
    private Context mContext;
    private List<OnMenuOpenListener> mOnMenuOpenListeners;

    public DropdownMenu(Context context) {
        this(context, null);
    }

    public DropdownMenu(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public DropdownMenu(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setOrientation(0);
        this.setWillNotDraw(false);
        this.mContext = context;
        this.mDividerPadding = DropdownMenu.dpToPx(this.mContext, this.mDividerPadding);
        this.mTabArrowLeftPadding = DropdownMenu.dpToPx(this.mContext, this.mTabArrowLeftPadding);
        this.mOnMenuOpenListeners = new ArrayList<OnMenuOpenListener>();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int measureHeight = this.getMeasuredHeight();
        int measuredWidth = this.getMeasuredWidth();
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        paint.setColor(this.mDividerColor);
        for (int i = 0; i < this.getChildCount() - 1; ++i) {
            View child = this.getChildAt(i);
            if (child == null || child.getVisibility() == 8) continue;
            canvas.drawLine((float)child.getRight(), (float)this.mDividerPadding, (float)child.getRight(), (float)(measureHeight - this.mDividerPadding), paint);
        }
        paint.setColor(this.mLineColor);
        canvas.drawRect(0.0f, 0.0f, (float)measuredWidth, (float)this.mLineHeight, paint);
        canvas.drawRect(0.0f, (float)(measureHeight - this.mLineHeight), (float)measuredWidth, (float)measureHeight, paint);
    }

    public void add(String title, OnMenuOpenListener onMenuOpenListener) {
        this.addTab(title);
        this.mOnMenuOpenListeners.add(onMenuOpenListener);
    }

    public void add(String title, List<DropdownListItem> list) {
        View popupWindowView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.popup_window, null, false);
        final PopupWindow popupWindow = new PopupWindow(popupWindowView, -1, -2, true);
        popupWindow.setBackgroundDrawable((Drawable)new ColorDrawable(0));
        popupWindow.setOnDismissListener(new PopupWindow.OnDismissListener(){

            public void onDismiss() {
                DropdownMenu.this.notifyMenuCanceled();
            }
        });
        View overlay = popupWindowView.findViewById(R.id.popup_window_overlay);
        overlay.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                popupWindow.dismiss();
            }
        });
        final DropdownListAdapter defaultAdapter = new DropdownListAdapter(this.mContext, title, list);
        ListView listView = (ListView)popupWindowView.findViewById(R.id.popup_window_list_view);
        listView.setAdapter((ListAdapter)defaultAdapter);
        listView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                defaultAdapter.setSelectedItem(position);
                DropdownMenu.this.setCurrentTitle(defaultAdapter.getSelectedItemString());
                popupWindow.dismiss();
            }
        });
        this.add(title, new OnMenuOpenListener(){

            @Override
            public void onOpen(View tabView, int tabIndex) {
                popupWindow.showAsDropDown((View)DropdownMenu.this);
            }
        });
    }

    public void notifyMenuCanceled() {
        this.setTabNormal(this.mCurrentTabIndex, null);
    }

    private View addTab(String title) {
        TextView titleTV = new TextView(this.mContext);
        titleTV.setGravity(17);
        titleTV.setText((CharSequence)title);
        titleTV.setTextSize(2, (float)this.mTabTextSize);
        titleTV.setTextColor(this.mTabNormalColor);
        titleTV.setSingleLine();
        titleTV.setEllipsize(TextUtils.TruncateAt.END);
        titleTV.setCompoundDrawablesWithIntrinsicBounds(null, null, this.getResources().getDrawable(R.drawable.level_filter), null);
        titleTV.setCompoundDrawablePadding(this.mTabArrowLeftPadding);
        RelativeLayout tabLayout = new RelativeLayout(this.mContext);
        RelativeLayout.LayoutParams titleParams = new RelativeLayout.LayoutParams(-2, -2);
        titleParams.addRule(13);
        tabLayout.addView((View)titleTV, (ViewGroup.LayoutParams)titleParams);
        tabLayout.setPaddingRelative(DropdownMenu.dpToPx(this.mContext, 5), 0, DropdownMenu.dpToPx(this.mContext, 5), 0);
        LinearLayout.LayoutParams tabParams = new LinearLayout.LayoutParams(-1, -1, 1.0f);
        tabParams.gravity = 17;
        tabLayout.setLayoutParams((ViewGroup.LayoutParams)tabParams);
        tabLayout.setOnClickListener((View.OnClickListener)new MyTabClickedListener(this.getChildCount()));
        this.addView((View)tabLayout);
        return tabLayout;
    }

    private TextView getTabTextViewAt(int index) {
        return (TextView)((ViewGroup)this.getChildAt(index)).getChildAt(0);
    }

    public void setCurrentTitle(String text) {
        this.setTabNormal(this.mCurrentTabIndex, text);
    }

    private void setTabNormal(int index, String title) {
        TextView tv = this.getTabTextViewAt(index);
        tv.setTextColor(this.mTabNormalColor);
        tv.getCompoundDrawables()[2].setLevel(0);
        if (title != null && title != "") {
            tv.setText((CharSequence)title);
        }
    }

    private void setTabActive(int index) {
        TextView tabTextView = this.getTabTextViewAt(index);
        tabTextView.setTextColor(this.mTabSelectedColor);
        tabTextView.getCompoundDrawables()[2].setLevel(1);
    }

    public static int dpToPx(Context context, int dp) {
        return (int)(TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)context.getResources().getDisplayMetrics()) + 0.5f);
    }

    private class MyTabClickedListener
    implements View.OnClickListener {
        private int mIndex;

        public MyTabClickedListener(int index) {
            this.mIndex = index;
        }

        public void onClick(View view) {
            DropdownMenu.this.setTabNormal(DropdownMenu.this.mCurrentTabIndex, null);
            DropdownMenu.this.setTabActive(this.mIndex);
            DropdownMenu.this.mCurrentTabIndex = this.mIndex;
            for (int i = 0; i < DropdownMenu.this.mOnMenuOpenListeners.size(); ++i) {
                if (i != DropdownMenu.this.mCurrentTabIndex) continue;
                ((OnMenuOpenListener)DropdownMenu.this.mOnMenuOpenListeners.get(i)).onOpen(view, i);
                break;
            }
        }
    }

    public static interface OnMenuOpenListener {
        public void onOpen(View var1, int var2);
    }
}

