/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.containers.ssh;

import com.exasol.containers.ssh.IdentityProvider;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.KeyPair;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.testcontainers.images.builder.Transferable;

public class SshKeys {
    private final KeyPair keyPair;
    private final byte[] passphrase;

    public static Builder builder() {
        return new Builder();
    }

    SshKeys(KeyPair keyPair) {
        this.keyPair = keyPair;
        this.passphrase = null;
    }

    public Transferable getPublicKeyTransferable() {
        return Transferable.of((byte[])this.getPublicKey());
    }

    byte[] getPublicKey() {
        ByteArrayOutputStream ba = new ByteArrayOutputStream();
        this.keyPair.writePublicKey((OutputStream)ba, "comment");
        return ba.toByteArray();
    }

    byte[] getPrivateKey() {
        ByteArrayOutputStream ba = new ByteArrayOutputStream();
        this.keyPair.writePrivateKey((OutputStream)ba);
        return ba.toByteArray();
    }

    byte[] getPassphrase() {
        return this.passphrase;
    }

    public IdentityProvider getIdentityProvider() {
        return IdentityProvider.builder().identityName("comment").publicKey(this.keyPair.getPublicKeyBlob()).privateKey(this.getPrivateKey()).passphrase(this.passphrase).build();
    }

    public static class Builder {
        Path priv;
        Path pub;

        public Builder privateKey(Path path) {
            this.priv = path;
            return this;
        }

        public Builder publicKey(Path path) {
            this.pub = path;
            return this;
        }

        public SshKeys build() throws IOException, JSchException {
            return new SshKeys(this.createKeyPair());
        }

        KeyPair createKeyPair() throws IOException, JSchException {
            if (Files.exists(this.priv, new LinkOption[0]) && Files.exists(this.pub, new LinkOption[0])) {
                return KeyPair.load((JSch)new JSch(), (byte[])this.read(this.priv), (byte[])this.read(this.pub));
            }
            return this.writeToFiles(KeyPair.genKeyPair((JSch)new JSch(), (int)2));
        }

        private byte[] read(Path path) throws IOException {
            try (InputStream stream = Files.newInputStream(path, new OpenOption[0]);){
                byte[] byArray = stream.readAllBytes();
                return byArray;
            }
        }

        private KeyPair writeToFiles(KeyPair keys) throws IOException {
            try (OutputStream stream = Files.newOutputStream(this.priv, new OpenOption[0]);){
                keys.writePrivateKey(stream);
            }
            stream = Files.newOutputStream(this.pub, new OpenOption[0]);
            try {
                keys.writePublicKey(stream, null);
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
            return keys;
        }
    }
}

