/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.containers.ssh;

import com.exasol.containers.ssh.FileVisitor;
import com.exasol.containers.ssh.Ssh;
import com.jcraft.jsch.JSchException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;

class RemoteFileReader {
    private final FileVisitor visitor;

    RemoteFileReader(Ssh ssh) {
        this.visitor = new FileVisitor(ssh);
    }

    String read(String rfile) throws IOException, JSchException {
        return this.visitor.visit(rfile, this::process);
    }

    String process(InputStream stream, Charset charset, int filesize) throws IOException {
        try (ByteArrayOutputStream fos = new ByteArrayOutputStream(filesize);){
            Reader reader = new Reader(filesize, fos);
            while (reader.read(stream) == FileVisitor.State.CONTINUE) {
            }
            String string = reader.output(charset);
            return string;
        }
    }

    static class Reader {
        private static final int BUFFER_SIZE = 1024;
        private final byte[] buf = new byte[1024];
        private int filesize;
        private final ByteArrayOutputStream out;

        Reader(int filesize, ByteArrayOutputStream out) {
            this.filesize = filesize;
            this.out = out;
        }

        FileVisitor.State read(InputStream in) throws IOException {
            int n = in.read(this.buf, 0, Math.min(this.filesize, this.buf.length));
            if (n < 0) {
                return FileVisitor.State.ERROR;
            }
            this.out.write(this.buf, 0, n);
            this.filesize -= n;
            if ((long)this.filesize == 0L) {
                return FileVisitor.State.COMPLETED;
            }
            return FileVisitor.State.CONTINUE;
        }

        String output(Charset charset) {
            return this.out.toString(charset);
        }
    }
}

