/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.config;

import com.exasol.config.BucketConfiguration;
import com.exasol.config.BucketFsServiceConfiguration;
import com.exasol.config.DatabaseServiceConfiguration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Collectors;

public class ClusterConfiguration {
    private static final String KEY_SEPARATOR = ":";
    private static final String BUCKET_SERVICE_KEY_PREFIX = "BucketFS:";
    private static final String BUCKET_KEY_PREFIX = "Bucket:";
    private static final String DATABASE_KEY_PREFIX = "DB:";
    private static final String SECTION_SEPARATOR = "/";
    private static final String GLOBAL_SECTION = "Global";
    private static final String SSL_SECTION = "SSL";
    private static final String DEFAULT_BUCKET_SECTION = "BucketFS:bfsdefault/Bucket:default";
    private static final String DEFAULT_DATABASE_NAME = "DB1";
    private final Map<String, String> parameters;

    public ClusterConfiguration(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public String getAuthenticationToken() {
        return this.parameters.get("Global/AuthenticationToken");
    }

    public String getDBVersion() {
        return this.parameters.get("Global/DBVersion");
    }

    public String getDefaultBucketReadPassword() {
        return this.parameters.get("BucketFS:bfsdefault/Bucket:default/ReadPasswd");
    }

    public String getDefaultBucketWritePassword() {
        return this.parameters.get("BucketFS:bfsdefault/Bucket:default/WritePasswd");
    }

    public String getTlsCertificatePath() {
        return this.parameters.get("SSL/Cert");
    }

    public BucketFsServiceConfiguration getBucketFsServiceConfiguration(String name) {
        String serviceKey = BUCKET_SERVICE_KEY_PREFIX + name;
        int httpPort = Integer.parseInt(this.getOrDefault(serviceKey, "HttpPort", "0"));
        int httpsPort = Integer.parseInt(this.getOrDefault(serviceKey, "HttpsPort", "0"));
        if (httpPort == 0 && httpsPort == 0) {
            throw new IllegalStateException("Found neither HTTP nor HTTPS port in parameters " + this.parameters);
        }
        BucketFsServiceConfiguration.Builder builder = BucketFsServiceConfiguration.builder().name(name).httpPort(httpPort).httpsPort(httpsPort);
        Set<String> bucketNames = this.getBucketNames(serviceKey);
        for (String bucketName : bucketNames) {
            this.addBucketConfiguration(serviceKey, bucketName, builder);
        }
        return builder.build();
    }

    private void addBucketConfiguration(String serviceKey, String bucketName, BucketFsServiceConfiguration.Builder builder) {
        String bucketKey = BUCKET_KEY_PREFIX + bucketName;
        builder.addBucketConfiguration(BucketConfiguration.builder().name(bucketName).readPassword(this.get(serviceKey, bucketKey, "ReadPasswd")).writePassword(this.get(serviceKey, bucketKey, "WritePasswd")).publiclyReadable("true".equalsIgnoreCase(this.getOrDefault(serviceKey, bucketKey, "Public", "false"))).build());
    }

    private Set<String> getBucketNames(String serviceKey) {
        return this.parameters.entrySet().stream().map(Map.Entry::getKey).filter(key -> key.startsWith(serviceKey + "/Bucket:")).map(key -> key.substring(key.lastIndexOf(KEY_SEPARATOR) + 1).replaceAll("/.*", "")).collect(Collectors.toSet());
    }

    private String getOrDefault(String sectionKey, String parameterKey, String defaultValue) {
        return this.parameters.getOrDefault(sectionKey + SECTION_SEPARATOR + parameterKey, defaultValue);
    }

    private String get(String sectionKey, String subSectionKey, String parameterKey) {
        return this.parameters.get(sectionKey + SECTION_SEPARATOR + subSectionKey + SECTION_SEPARATOR + parameterKey);
    }

    private String getOrDefault(String sectionKey, String subSectionKey, String parameterKey, String defaultValue) {
        return this.parameters.getOrDefault(sectionKey + SECTION_SEPARATOR + subSectionKey + SECTION_SEPARATOR + parameterKey, defaultValue);
    }

    public boolean containsDatabaseService(String databaseName) {
        return this.parameters.keySet().stream().anyMatch(key -> key.startsWith(DATABASE_KEY_PREFIX + databaseName));
    }

    public List<String> getDatabaseNames() {
        return this.parameters.keySet().stream().filter(key -> key.startsWith(DATABASE_KEY_PREFIX)).map(key -> key.substring(key.lastIndexOf(KEY_SEPARATOR) + 1).replaceAll("/.*", "")).distinct().collect(Collectors.toList());
    }

    public TimeZone getTimeZone() {
        return TimeZone.getTimeZone(this.parameters.get("Global/Timezone"));
    }

    public DatabaseServiceConfiguration getDefaultDatabaseServiceConfiguration() {
        return this.getDatabaseServiceConfiguration(DEFAULT_DATABASE_NAME);
    }

    public DatabaseServiceConfiguration getDatabaseServiceConfiguration(String databaseName) {
        return DatabaseServiceConfiguration.builder().databaseName(databaseName).port(Integer.parseInt(this.parameters.get(DATABASE_KEY_PREFIX + databaseName + "/Port"))).build();
    }

    public DatabaseServiceConfiguration getDatabaseServiceConfiguration(int position) {
        return this.getDatabaseServiceConfiguration(this.getDatabaseNames().get(position));
    }

    public List<String> getBucketFsServiceNames() {
        return this.parameters.keySet().stream().filter(key -> key.startsWith(BUCKET_SERVICE_KEY_PREFIX)).map(key -> key.substring(key.indexOf(KEY_SEPARATOR) + 1).replaceAll("/.*", "")).distinct().collect(Collectors.toList());
    }
}

