/*
 * Decompiled with CFR 0.152.
 */
package resources.dependencies.org.bouncycastle.operator.bc;

import java.io.IOException;
import resources.dependencies.org.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import resources.dependencies.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import resources.dependencies.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import resources.dependencies.org.bouncycastle.crypto.Signer;
import resources.dependencies.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import resources.dependencies.org.bouncycastle.crypto.signers.Ed25519Signer;
import resources.dependencies.org.bouncycastle.crypto.signers.Ed448Signer;
import resources.dependencies.org.bouncycastle.crypto.util.PublicKeyFactory;
import resources.dependencies.org.bouncycastle.operator.OperatorCreationException;
import resources.dependencies.org.bouncycastle.operator.bc.BcContentVerifierProviderBuilder;

public class BcEdDSAContentVerifierProviderBuilder
extends BcContentVerifierProviderBuilder {
    public static final byte[] DEFAULT_CONTEXT = new byte[0];

    @Override
    protected Signer createSigner(AlgorithmIdentifier algorithmIdentifier) throws OperatorCreationException {
        if (algorithmIdentifier.getAlgorithm().equals(EdECObjectIdentifiers.id_Ed448)) {
            return new Ed448Signer(DEFAULT_CONTEXT);
        }
        return new Ed25519Signer();
    }

    @Override
    protected AsymmetricKeyParameter extractKeyParameters(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        return PublicKeyFactory.createKey(subjectPublicKeyInfo);
    }
}

