/*
 * Decompiled with CFR 0.152.
 */
package resources.dependencies.org.bouncycastle.jcajce.provider.asymmetric.dstu;

import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import resources.dependencies.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import resources.dependencies.org.bouncycastle.asn1.ua.DSTU4145NamedCurves;
import resources.dependencies.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import resources.dependencies.org.bouncycastle.crypto.generators.DSTU4145KeyPairGenerator;
import resources.dependencies.org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import resources.dependencies.org.bouncycastle.crypto.params.DSTU4145Parameters;
import resources.dependencies.org.bouncycastle.crypto.params.ECDomainParameters;
import resources.dependencies.org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import resources.dependencies.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import resources.dependencies.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import resources.dependencies.org.bouncycastle.jcajce.provider.asymmetric.dstu.BCDSTU4145PrivateKey;
import resources.dependencies.org.bouncycastle.jcajce.provider.asymmetric.dstu.BCDSTU4145PublicKey;
import resources.dependencies.org.bouncycastle.jcajce.provider.asymmetric.util.EC5Util;
import resources.dependencies.org.bouncycastle.jcajce.spec.DSTU4145ParameterSpec;
import resources.dependencies.org.bouncycastle.jce.provider.BouncyCastleProvider;
import resources.dependencies.org.bouncycastle.jce.spec.ECNamedCurveGenParameterSpec;
import resources.dependencies.org.bouncycastle.jce.spec.ECNamedCurveSpec;
import resources.dependencies.org.bouncycastle.math.ec.ECCurve;
import resources.dependencies.org.bouncycastle.math.ec.ECPoint;

public class KeyPairGeneratorSpi
extends KeyPairGenerator {
    Object ecParams = null;
    ECKeyPairGenerator engine = new DSTU4145KeyPairGenerator();
    String algorithm = "DSTU4145";
    ECKeyGenerationParameters param;
    SecureRandom random = null;
    boolean initialised = false;

    public KeyPairGeneratorSpi() {
        super("DSTU4145");
    }

    @Override
    public void initialize(int n, SecureRandom secureRandom) {
        this.random = secureRandom;
        if (this.ecParams != null) {
            try {
                this.initialize((ECGenParameterSpec)this.ecParams, secureRandom);
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new InvalidParameterException("key size not configurable.");
            }
        } else {
            throw new InvalidParameterException("unknown key size.");
        }
    }

    @Override
    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (algorithmParameterSpec instanceof resources.dependencies.org.bouncycastle.jce.spec.ECParameterSpec) {
            resources.dependencies.org.bouncycastle.jce.spec.ECParameterSpec eCParameterSpec = (resources.dependencies.org.bouncycastle.jce.spec.ECParameterSpec)algorithmParameterSpec;
            this.ecParams = algorithmParameterSpec;
            this.param = new ECKeyGenerationParameters(new ECDomainParameters(eCParameterSpec.getCurve(), eCParameterSpec.getG(), eCParameterSpec.getN(), eCParameterSpec.getH()), secureRandom);
            this.engine.init(this.param);
            this.initialised = true;
        } else if (algorithmParameterSpec instanceof ECParameterSpec) {
            ECParameterSpec eCParameterSpec = (ECParameterSpec)algorithmParameterSpec;
            this.ecParams = algorithmParameterSpec;
            ECCurve eCCurve = EC5Util.convertCurve(eCParameterSpec.getCurve());
            ECPoint eCPoint = EC5Util.convertPoint(eCCurve, eCParameterSpec.getGenerator());
            if (eCParameterSpec instanceof DSTU4145ParameterSpec) {
                DSTU4145ParameterSpec dSTU4145ParameterSpec = (DSTU4145ParameterSpec)eCParameterSpec;
                this.param = new ECKeyGenerationParameters(new DSTU4145Parameters(new ECDomainParameters(eCCurve, eCPoint, eCParameterSpec.getOrder(), BigInteger.valueOf(eCParameterSpec.getCofactor())), dSTU4145ParameterSpec.getDKE()), secureRandom);
            } else {
                this.param = new ECKeyGenerationParameters(new ECDomainParameters(eCCurve, eCPoint, eCParameterSpec.getOrder(), BigInteger.valueOf(eCParameterSpec.getCofactor())), secureRandom);
            }
            this.engine.init(this.param);
            this.initialised = true;
        } else if (algorithmParameterSpec instanceof ECGenParameterSpec || algorithmParameterSpec instanceof ECNamedCurveGenParameterSpec) {
            String string = algorithmParameterSpec instanceof ECGenParameterSpec ? ((ECGenParameterSpec)algorithmParameterSpec).getName() : ((ECNamedCurveGenParameterSpec)algorithmParameterSpec).getName();
            ECDomainParameters eCDomainParameters = DSTU4145NamedCurves.getByOID(new ASN1ObjectIdentifier(string));
            if (eCDomainParameters == null) {
                throw new InvalidAlgorithmParameterException("unknown curve name: " + string);
            }
            this.ecParams = new ECNamedCurveSpec(string, eCDomainParameters.getCurve(), eCDomainParameters.getG(), eCDomainParameters.getN(), eCDomainParameters.getH(), eCDomainParameters.getSeed());
            ECParameterSpec eCParameterSpec = (ECParameterSpec)this.ecParams;
            ECCurve eCCurve = EC5Util.convertCurve(eCParameterSpec.getCurve());
            ECPoint eCPoint = EC5Util.convertPoint(eCCurve, eCParameterSpec.getGenerator());
            this.param = new ECKeyGenerationParameters(new ECDomainParameters(eCCurve, eCPoint, eCParameterSpec.getOrder(), BigInteger.valueOf(eCParameterSpec.getCofactor())), secureRandom);
            this.engine.init(this.param);
            this.initialised = true;
        } else if (algorithmParameterSpec == null && BouncyCastleProvider.CONFIGURATION.getEcImplicitlyCa() != null) {
            resources.dependencies.org.bouncycastle.jce.spec.ECParameterSpec eCParameterSpec = BouncyCastleProvider.CONFIGURATION.getEcImplicitlyCa();
            this.ecParams = algorithmParameterSpec;
            this.param = new ECKeyGenerationParameters(new ECDomainParameters(eCParameterSpec.getCurve(), eCParameterSpec.getG(), eCParameterSpec.getN(), eCParameterSpec.getH()), secureRandom);
            this.engine.init(this.param);
            this.initialised = true;
        } else {
            if (algorithmParameterSpec == null && BouncyCastleProvider.CONFIGURATION.getEcImplicitlyCa() == null) {
                throw new InvalidAlgorithmParameterException("null parameter passed but no implicitCA set");
            }
            throw new InvalidAlgorithmParameterException("parameter object not a ECParameterSpec: " + algorithmParameterSpec.getClass().getName());
        }
    }

    @Override
    public KeyPair generateKeyPair() {
        if (!this.initialised) {
            throw new IllegalStateException("DSTU Key Pair Generator not initialised");
        }
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = this.engine.generateKeyPair();
        ECPublicKeyParameters eCPublicKeyParameters = (ECPublicKeyParameters)asymmetricCipherKeyPair.getPublic();
        ECPrivateKeyParameters eCPrivateKeyParameters = (ECPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
        if (this.ecParams instanceof resources.dependencies.org.bouncycastle.jce.spec.ECParameterSpec) {
            resources.dependencies.org.bouncycastle.jce.spec.ECParameterSpec eCParameterSpec = (resources.dependencies.org.bouncycastle.jce.spec.ECParameterSpec)this.ecParams;
            BCDSTU4145PublicKey bCDSTU4145PublicKey = new BCDSTU4145PublicKey(this.algorithm, eCPublicKeyParameters, eCParameterSpec);
            return new KeyPair(bCDSTU4145PublicKey, new BCDSTU4145PrivateKey(this.algorithm, eCPrivateKeyParameters, bCDSTU4145PublicKey, eCParameterSpec));
        }
        if (this.ecParams == null) {
            return new KeyPair(new BCDSTU4145PublicKey(this.algorithm, eCPublicKeyParameters), new BCDSTU4145PrivateKey(this.algorithm, eCPrivateKeyParameters));
        }
        ECParameterSpec eCParameterSpec = (ECParameterSpec)this.ecParams;
        BCDSTU4145PublicKey bCDSTU4145PublicKey = new BCDSTU4145PublicKey(this.algorithm, eCPublicKeyParameters, eCParameterSpec);
        return new KeyPair(bCDSTU4145PublicKey, new BCDSTU4145PrivateKey(this.algorithm, eCPrivateKeyParameters, bCDSTU4145PublicKey, eCParameterSpec));
    }
}

