/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc.importExport;

import com.exasol.jdbc.DebugLog;
import com.exasol.jdbc.EXADriver;
import com.exasol.jdbc.Translator;
import com.exasol.jdbc.importExport.HttpPush;
import com.exasol.jdbc.importExport.HttpPushTool;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;

public class HTTPThread
extends Thread {
    private HttpPush hp = null;
    private String[] fileNames = null;
    private String cookie = null;
    private boolean connected = false;
    private boolean interrupted = false;
    public IOException ioException;
    public Error error;
    public RuntimeException runtimeException;
    public InterruptedException interruptException;
    final DebugLog debug;
    final PrintStream logPrinterOut;
    final PrintStream logPrinterErr;

    public void InterruptThread() throws IOException {
        this.interrupted = true;
        this.hp.close();
    }

    public boolean ThreadWasInterrupted() {
        return this.interrupted;
    }

    public HTTPThread(HttpPush Ahp, String[] fns, String ck, DebugLog log, PrintStream logPrinterOut, PrintStream logPrinterErr) {
        this.hp = Ahp;
        this.fileNames = fns;
        this.cookie = ck;
        this.debug = log;
        this.logPrinterOut = logPrinterOut;
        this.logPrinterErr = logPrinterErr;
        this.logOut("HTTPThread successfully constructed");
    }

    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public void run() {
        try {
            this.hp.connect(this);
            String command = this.hp.getCommand();
            String url = this.hp.getURL();
            if (!url.endsWith(this.cookie)) {
                throw new IOException(Translator.WrongCookieRecieved());
            }
            HashMap hd = this.hp.getHeader();
            this.logOut("[" + command + ": " + url + "]");
            for (Map.Entry entry : hd.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                this.logOut("<" + key + ": " + value + ">");
            }
            String filename = "";
            try {
                if (command.equals("GET")) {
                    if (this.fileNames.length != 1 || !this.fileNames[0].equals("System.in")) {
                        for (int i = 0; i < this.fileNames.length; ++i) {
                            filename = this.fileNames[i];
                            File f = new File(filename);
                            if (null == f || !f.exists()) {
                                this.logOut(Translator.File(filename) + " " + Translator.not_found());
                                throw new FileNotFoundException(Translator.File(filename) + " " + Translator.not_found());
                            }
                            if (!f.canRead()) {
                                this.logOut(Translator.File(filename) + " " + Translator.Permission_denied());
                                throw new FileNotFoundException(Translator.File(filename) + " " + Translator.Permission_denied());
                            }
                            this.logOut(Translator.UploadFileFrom(filename));
                        }
                    }
                    try (HttpPushTool.PushFiles pf = new HttpPushTool.PushFiles(this.fileNames);){
                        this.hp.push(pf);
                    }
                } else if (command.equals("PUT")) {
                    String append = (String)hd.get("X-Append");
                    filename = this.fileNames[0];
                    if (append != null && append.trim().equalsIgnoreCase("yes")) {
                        this.logOut(Translator.DownloadToFile_Append(filename));
                        this.hp.pull(new HttpPushTool.PullFile(filename, true));
                    } else {
                        this.logOut(Translator.DownloadToFile_Replace(filename));
                        this.hp.pull(new HttpPushTool.PullFile(filename, false));
                    }
                }
                this.hp.close();
            }
            catch (SecurityException ex) {
                this.logOut(Translator.File(filename) + " " + Translator.Permission_denied());
                throw new FileNotFoundException(Translator.File(filename) + " " + Translator.Permission_denied());
            }
        }
        catch (FileNotFoundException fex) {
            try {
                String exMsg = fex.toString();
                if (exMsg != null && exMsg.indexOf(Translator.Permission_denied()) >= 0) {
                    this.hp.pushPermissionDenied(exMsg);
                } else {
                    this.hp.pushFileNotFound(exMsg);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.hp.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.logErr("Error:");
            this.logErr(fex.toString());
            this.ioException = fex;
        }
        catch (IOException ex) {
            try {
                this.hp.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.logErr("Error:");
            this.logErr(ex);
            this.ioException = ex;
        }
        catch (InterruptedException ex) {
            try {
                this.hp.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.logOut("Interrupted:" + ex.toString());
            this.interruptException = ex;
        }
        catch (RuntimeException ex) {
            try {
                this.hp.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.logOut("RuntimeException:" + ex.toString());
            this.runtimeException = ex;
        }
        catch (Error error) {
            this.error = error;
        }
    }

    public void checkForErrors() throws IOException {
        if (this.ioException != null) {
            throw this.ioException;
        }
        if (this.runtimeException != null) {
            throw this.runtimeException;
        }
        if (this.error != null) {
            throw this.error;
        }
        try {
            int ms = 0;
            while (this.isConnected() && ms++ < 4999) {
                Thread.sleep(1L);
            }
            this.join(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.isAlive()) {
            throw new IOException(Translator.ThreadFromImportExportHasNotBeenFinished());
        }
    }

    public void logOut(String msg) {
        if (this.debug != null) {
            this.debug.log(this.getClass().getSimpleName() + ": " + msg);
        }
        if (this.logPrinterOut != null) {
            this.logPrinterOut.println(this.getClass().getSimpleName() + ": " + msg);
        }
    }

    public void logErr(String msg) {
        if (this.debug != null) {
            this.debug.log(this.getClass().getSimpleName() + ": " + msg);
        }
        if (this.logPrinterErr != null) {
            this.logPrinterErr.println(this.getClass().getSimpleName() + ": " + msg);
        }
    }

    public void logErr(Throwable t) {
        if (this.debug != null) {
            EXADriver.debugError(this.getClass().getSimpleName() + ": ", t, this.debug);
        }
        if (this.logPrinterErr != null) {
            t.printStackTrace(this.logPrinterErr);
        }
    }

    public synchronized void NowConnected() {
        this.connected = true;
    }

    public synchronized void NowDisconnected() {
        this.connected = false;
    }
}

