/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc;

import com.exasol.jdbc.EXAConnection;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.List;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import javax.sql.StatementEvent;
import javax.sql.StatementEventListener;

public class EXAPooledConnection
implements PooledConnection {
    private Connection conn = null;
    private String exaURL = null;
    private String exaUser = null;
    private String exaPassword = null;
    private boolean occupied = false;
    List<ConnectionEventListener> connEventListeners = new ArrayList<ConnectionEventListener>();
    List<StatementEventListener> stmtEventListeners = new ArrayList<StatementEventListener>();

    public synchronized boolean isOccupied() {
        return this.occupied;
    }

    public void setURL(String url) {
        this.exaURL = url;
    }

    public String getURL() {
        return this.exaURL;
    }

    public void setUrl(String url) {
        this.setURL(url);
    }

    public void setUser(String uid) {
        this.exaUser = uid;
    }

    public String getUser() {
        return this.exaUser;
    }

    public void setPassword(String pwd) {
        this.exaPassword = pwd;
    }

    public String getPassword() {
        return this.exaPassword;
    }

    public void clearListeners() {
        if (this.connEventListeners.size() > 0) {
            this.connEventListeners = new ArrayList<ConnectionEventListener>();
        }
        if (this.stmtEventListeners.size() > 0) {
            this.stmtEventListeners = new ArrayList<StatementEventListener>();
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.conn == null) {
            try {
                Class.forName("com.exasol.jdbc.EXADriver");
            }
            catch (ClassNotFoundException cex) {
                throw new SQLException(cex.toString());
            }
            this.conn = DriverManager.getConnection(this.exaURL, this.exaUser, this.exaPassword);
            ((EXAConnection)this.conn).setPool(this);
            ((EXAConnection)this.conn).clientLog("EXAPooledConnection: getConnection() - new");
            if (this.conn != null) {
                ((EXAConnection)this.conn).clientLog("from EXAPooledConnection: connect()");
            }
        } else if (!this.occupied) {
            ((EXAConnection)this.conn).clientLog("EXAPooledConnection: getConnection() - connection can be reused from the pool");
        } else {
            ((EXAConnection)this.conn).clientLog("EXAPooledConnection: getConnection() - connection exitst allready and will be closed and reopened");
            this.close();
            return this.getConnection();
        }
        this.occupied = true;
        return this.conn;
    }

    @Override
    public synchronized void close() throws SQLException {
        if (this.conn != null) {
            ((EXAConnection)this.conn).clientLog("EXAPooledConnection: close()");
            if (!((EXAConnection)this.conn).wasDisconnected) {
                ((EXAConnection)this.conn).closeBase();
            }
        }
        this.occupied = false;
        this.conn = null;
    }

    public synchronized void free() throws SQLException {
        if (!this.occupied) {
            return;
        }
        if (this.conn != null) {
            ((EXAConnection)this.conn).clientLog("EXAPooledConnection: free()");
            if (this.connEventListeners.size() > 0) {
                try {
                    for (ConnectionEventListener ce : this.connEventListeners) {
                        ce.connectionClosed(new ConnectionEvent(this, null));
                    }
                }
                catch (ConcurrentModificationException cme) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.free();
                    return;
                }
            }
            if (this.conn != null) {
                this.conn.rollback();
            }
        }
        this.occupied = false;
    }

    @Override
    public void addConnectionEventListener(ConnectionEventListener listener) {
        if (this.conn != null) {
            ((EXAConnection)this.conn).clientLog("EXAPooledConnection: addConnectionEventListener()");
        }
        this.connEventListeners.add(listener);
    }

    @Override
    public void removeConnectionEventListener(ConnectionEventListener listener) {
        if (this.conn != null) {
            ((EXAConnection)this.conn).clientLog("EXAPooledConnection: removeConnectionEventListener()");
        }
        try {
            this.connEventListeners.remove(listener);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void addStatementEventListener(StatementEventListener listener) {
        if (this.conn != null) {
            ((EXAConnection)this.conn).clientLog("EXAPooledConnection: addStatementEventListener()");
        }
        this.stmtEventListeners.add(listener);
    }

    @Override
    public void removeStatementEventListener(StatementEventListener listener) {
        if (this.conn != null) {
            ((EXAConnection)this.conn).clientLog("EXAPooledConnection: removeStatementEventListener()");
        }
        try {
            this.stmtEventListeners.remove(listener);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void isNowOccupied() {
        this.occupied = true;
    }

    public Object getConnectionPtr() {
        return this.conn;
    }

    public void connectionError(SQLException sex) {
        if (this.connEventListeners.size() > 0) {
            for (ConnectionEventListener ce : this.connEventListeners) {
                if (sex == null) {
                    ce.connectionErrorOccurred(new ConnectionEvent(this));
                    continue;
                }
                ce.connectionErrorOccurred(new ConnectionEvent(this, sex));
            }
        }
    }

    public void statementError(PooledConnection con, PreparedStatement statement, SQLException sex) {
        if (this.stmtEventListeners.size() > 0) {
            for (StatementEventListener se : this.stmtEventListeners) {
                if (sex == null) {
                    se.statementErrorOccurred(new StatementEvent(con, statement));
                    continue;
                }
                se.statementErrorOccurred(new StatementEvent(con, statement, sex));
            }
        }
    }
}

