/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc;

import com.exasol.jdbc.Column;
import com.exasol.jdbc.SimpleDate;
import com.exasol.jdbc.exaTimestamp;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.TimeZone;

public abstract class DateTimeColumn
extends Column {
    protected Calendar defCal = Calendar.getInstance();
    protected Calendar utcCal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));

    DateTimeColumn() {
    }

    DateTimeColumn(String name_) {
        super(name_);
    }

    protected Date dateFromCalendar(exaTimestamp exaTs, Calendar cal) {
        Calendar tscal = cal == this.defCal ? this.defCal : Calendar.getInstance(cal.getTimeZone());
        return exaTs.getDate(tscal);
    }

    protected Time timeFromCalendar(exaTimestamp exaTs, Calendar cal) {
        Calendar tscal = cal == this.defCal ? this.defCal : Calendar.getInstance(cal.getTimeZone());
        return exaTs.getTime(tscal);
    }

    protected Timestamp timestampFromCalendar(exaTimestamp exaTs, Calendar cal) {
        Calendar tscal = cal == this.defCal ? this.defCal : Calendar.getInstance(cal.getTimeZone());
        return exaTs.getTimestamp(tscal);
    }

    protected void simpleDateFromCalendar(SimpleDate dt, long millis, Calendar cal) {
        Calendar dCal = cal == this.defCal ? this.defCal : Calendar.getInstance(cal.getTimeZone());
        dCal.setTimeInMillis(millis);
        dt.fromCalendar(dCal);
    }

    protected exaTimestamp exaTimestampFromCalendar(long time, Calendar cal) {
        Calendar tscal = cal == this.defCal ? this.defCal : Calendar.getInstance(cal.getTimeZone());
        tscal.setTimeInMillis(time);
        return new exaTimestamp((short)tscal.get(1), (byte)tscal.get(2), (byte)tscal.get(5), (byte)tscal.get(11), (byte)tscal.get(12), (byte)tscal.get(13), 0);
    }
}

