/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.dbcleaner;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.logging.Logger;

public class ExasolDatabaseCleaner {
    private static final Logger LOGGER = Logger.getLogger(ExasolDatabaseCleaner.class.getName());
    private final Statement statement;

    public ExasolDatabaseCleaner(Statement statement) {
        this.statement = statement;
    }

    public void cleanDatabase() throws SQLException {
        this.purgeObjects();
        this.purgeConnections();
        this.purgeUsers();
        this.purgeRoles();
    }

    private void purgeConnections() throws SQLException {
        try (ResultSet resultSet = this.statement.executeQuery("SELECT CONNECTION_NAME FROM EXA_ALL_CONNECTIONS");){
            while (resultSet.next()) {
                String connectionName = resultSet.getString("CONNECTION_NAME");
                String dropCommand = "DROP CONNECTION IF EXISTS \"" + connectionName + "\"";
                LOGGER.fine(dropCommand);
                this.statement.executeUpdate(dropCommand);
            }
        }
    }

    private void purgeObjects() throws SQLException {
        try (ResultSet resultSet = this.statement.executeQuery("SELECT OBJECT_NAME, OBJECT_TYPE, OBJECT_IS_VIRTUAL FROM SYS.EXA_ALL_OBJECTS WHERE ROOT_NAME IS NULL ORDER BY CREATED DESC");){
            while (resultSet.next()) {
                String objectName = resultSet.getString("OBJECT_NAME");
                String objectType = (resultSet.getBoolean("OBJECT_IS_VIRTUAL") ? "VIRTUAL " : "") + resultSet.getString("OBJECT_TYPE");
                this.dropObject(objectName, objectType);
            }
        }
    }

    private void dropObject(String objectName, String objectType) throws SQLException {
        if (objectType.equals("VIRTUAL TABLE") || objectType.equals("TABLE") || objectType.equals("SCRIPT")) {
            return;
        }
        StringBuilder dropCommandBuilder = new StringBuilder("DROP ");
        if (objectType.equals("VIRTUAL SCHEMA")) {
            dropCommandBuilder.append("FORCE ");
        }
        dropCommandBuilder.append(objectType).append(" IF EXISTS \"").append(objectName).append("\"");
        if (objectType.equals("SCHEMA") || objectType.equals("VIRTUAL SCHEMA")) {
            dropCommandBuilder.append(" CASCADE");
        }
        String dropCommand = dropCommandBuilder.toString();
        LOGGER.fine(dropCommand);
        this.statement.executeUpdate(dropCommand);
    }

    private void purgeUsers() throws SQLException {
        try (ResultSet resultSet = this.statement.executeQuery("SELECT USER_NAME FROM EXA_ALL_USERS");){
            while (resultSet.next()) {
                String userName = resultSet.getString("USER_NAME");
                if (userName.equals("SYS")) continue;
                String dropCommand = "DROP USER \"" + userName + "\"";
                LOGGER.fine(dropCommand);
                this.statement.executeUpdate(dropCommand);
            }
        }
    }

    private void purgeRoles() throws SQLException {
        List<String> builtInRoles = List.of("PUBLIC", "DBA");
        try (ResultSet resultSet = this.statement.executeQuery("SELECT ROLE_NAME FROM EXA_ALL_ROLES");){
            while (resultSet.next()) {
                String roleName = resultSet.getString("ROLE_NAME");
                if (builtInRoles.contains(roleName)) continue;
                String dropCommand = "DROP ROLE \"" + roleName + "\"";
                LOGGER.fine(dropCommand);
                this.statement.executeUpdate(dropCommand);
            }
        }
    }
}

