/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.bucketfs.jsonrpc;

import com.exasol.bucketfs.jsonrpc.Authenticator;
import java.net.http.HttpRequest;
import java.util.Base64;

class BasicAuthAuthenticator
implements Authenticator {
    private final String username;
    private final String password;
    private final Base64.Encoder base64Encoder;

    BasicAuthAuthenticator(String username, String password) {
        this.username = username;
        this.password = password;
        this.base64Encoder = Base64.getEncoder();
    }

    @Override
    public void authenticate(HttpRequest.Builder requestBuilder) {
        requestBuilder.header("Authorization", this.basicAuth(this.username, this.password));
    }

    private String basicAuth(String username, String password) {
        return "Basic " + this.base64Encoder.encodeToString((username + ":" + password).getBytes());
    }
}

