/*
 * Decompiled with CFR 0.152.
 */
package com.example.mzy.indicators.Rect;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.Log;
import android.view.animation.LinearInterpolator;
import com.example.mzy.indicators.IndicatorDrawable;
import java.util.ArrayList;

public class RectJumpMoveIndicator
extends IndicatorDrawable {
    private final String TAG = RectJumpMoveIndicator.class.getSimpleName();
    private final int mCount = 5;
    private int mState = 0;
    private float mPreviousAnimatedValue = 0.0f;
    private float mAnimatedValue = 0.0f;
    private RectF rectF = new RectF();
    private boolean drawAssist = false;
    private int currentJumpIndex = 0;

    public RectJumpMoveIndicator(Context context, int indicatorColor, int indicatorSpeed) {
        Log.d((String)this.TAG, (String)"RectJumpMoveIndicator: ");
        this.indicatorColor = indicatorColor;
        this.indicatorSpeed = indicatorSpeed;
        if (indicatorSpeed <= 0) {
            this.indicatorSpeed = 2000;
        }
        this.init(context);
    }

    @Override
    protected void init(Context context) {
        Log.d((String)this.TAG, (String)"init: ");
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setStrokeWidth(RectJumpMoveIndicator.dip2px(context, 1.0f));
        this.mPaint.setColor(this.indicatorColor);
    }

    @Override
    protected ArrayList<Animator> getAnimation() {
        ArrayList<Animator> list = new ArrayList<Animator>();
        ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 0.0f, 1.0f, 1.0f});
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                RectJumpMoveIndicator.this.mAnimatedValue = ((Float)valueAnimator.getAnimatedValue()).floatValue();
                if (RectJumpMoveIndicator.this.mAnimatedValue - RectJumpMoveIndicator.this.mPreviousAnimatedValue > 0.0f) {
                    RectJumpMoveIndicator.this.mState = 1;
                } else if (RectJumpMoveIndicator.this.mAnimatedValue - RectJumpMoveIndicator.this.mPreviousAnimatedValue < 0.0f) {
                    RectJumpMoveIndicator.this.mState = 2;
                } else {
                    RectJumpMoveIndicator.this.mState = 0;
                }
                RectJumpMoveIndicator.this.mPreviousAnimatedValue = RectJumpMoveIndicator.this.mAnimatedValue;
                RectJumpMoveIndicator.this.invalidateSelf();
            }
        });
        valueAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        valueAnimator.setRepeatMode(2);
        valueAnimator.setRepeatCount(-1);
        valueAnimator.setDuration((long)this.indicatorSpeed);
        list.add((Animator)valueAnimator);
        return list;
    }

    private void drawAssist(Canvas canvas, Paint paint) {
        if (this.drawAssist) {
            canvas.drawColor(-65536);
            canvas.drawLine((float)(this.getWidth() / 2), 0.0f, (float)(this.getWidth() / 2), (float)this.getHeight(), paint);
            canvas.drawLine(0.0f, (float)(this.getHeight() / 2), (float)this.getWidth(), (float)(this.getHeight() / 2), paint);
        }
    }

    @Override
    protected void draw(Canvas canvas, Paint paint) {
        canvas.save();
        this.drawAssist(canvas, paint);
        this.drawRect(canvas, paint);
        canvas.restore();
    }

    private void drawRect(Canvas canvas, Paint paint) {
        float left_i;
        int i;
        float left_i2;
        int i2;
        float rectWidth = this.getWidth() / 15;
        float rectSpace = this.getWidth() / 30;
        float canMoveMax = (rectWidth + rectSpace) * 4.0f;
        float startX = ((float)this.getWidth() - (canMoveMax + rectWidth)) / 2.0f;
        if (this.drawAssist) {
            for (i2 = 0; i2 < 5; ++i2) {
                left_i2 = startX + (float)i2 * (rectWidth + rectSpace);
                canvas.drawLine(left_i2, 100.0f, left_i2, (float)(this.getHeight() - 100), paint);
            }
        }
        if (this.mState == 0) {
            for (i2 = 0; i2 < 5; ++i2) {
                left_i2 = startX + (float)i2 * (rectWidth + rectSpace);
                float top = (float)(this.getHeight() / 2) - rectWidth / 2.0f;
                this.rectF.setEmpty();
                this.rectF.set(left_i2, top, left_i2 + rectWidth, (float)(this.getHeight() / 2) + rectWidth / 2.0f);
                canvas.drawRoundRect(this.rectF, 5.0f, 5.0f, paint);
            }
            return;
        }
        float movedRectX = startX + canMoveMax * this.mAnimatedValue;
        float moved_ = canMoveMax * this.mAnimatedValue % (rectWidth + rectSpace);
        float percent = moved_ / (rectWidth + rectSpace);
        this.rectF.setEmpty();
        this.rectF.set(movedRectX, (float)(this.getHeight() / 2) - rectWidth / 2.0f, movedRectX + rectWidth, (float)(this.getHeight() / 2) + rectWidth / 2.0f);
        canvas.drawRoundRect(this.rectF, 5.0f, 5.0f, paint);
        int currentMoveIndex = 0;
        for (i = 0; i < 5; ++i) {
            left_i = startX + (float)i * (rectWidth + rectSpace);
            float left_next_i = startX + (float)(i + 1) * (rectWidth + rectSpace);
            if (!(movedRectX >= left_i) || !(movedRectX <= left_next_i)) continue;
            int degree = -((int)(moved_ * 180.0f / (rectWidth + rectSpace)));
            float radius = rectWidth / 2.0f + rectSpace / 2.0f;
            double angle = (double)degree * Math.PI / 180.0;
            float x = radius * (float)Math.cos(angle);
            float y = radius * (float)Math.sin(angle);
            float centerX = left_i + rectWidth + rectSpace / 2.0f;
            float l = centerX + x - rectWidth / 2.0f;
            float t = (float)(this.getHeight() / 2) - rectWidth / 2.0f + y;
            float r = l + rectWidth;
            float b = t + rectWidth;
            this.rectF.setEmpty();
            this.rectF.set(l, t, r, b);
            if (this.mState == 1) {
                this.currentJumpIndex = i + 1;
                currentMoveIndex = i;
            } else if (this.mState == 2) {
                this.currentJumpIndex = i;
                currentMoveIndex = i + 1;
            }
            canvas.drawRoundRect(this.rectF, 5.0f, 5.0f, paint);
            break;
        }
        for (i = 0; i < 5; ++i) {
            if (i == this.currentJumpIndex || i == currentMoveIndex) continue;
            left_i = startX + (float)i * (rectWidth + rectSpace);
            float top = (float)(this.getHeight() / 2) - rectWidth / 2.0f;
            int shakeIndex = 0;
            if (this.mState == 1) {
                shakeIndex = this.currentJumpIndex - 2;
            } else if (this.mState == 2) {
                shakeIndex = this.currentJumpIndex + 2;
            }
            if (i == shakeIndex) {
                if ((double)percent <= 0.5) {
                    top += rectWidth * percent;
                } else if ((double)percent > 0.5 && (double)percent <= 1.0) {
                    top += rectWidth * (1.0f - percent);
                }
            }
            this.rectF.setEmpty();
            this.rectF.set(left_i, top, left_i + rectWidth, (float)(this.getHeight() / 2) + rectWidth / 2.0f);
            canvas.drawRoundRect(this.rectF, 5.0f, 5.0f, paint);
        }
    }
}

