/*
 * Decompiled with CFR 0.152.
 */
package com.example.mzy.indicators.Rect;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.Log;
import com.example.mzy.indicators.IndicatorDrawable;
import java.util.ArrayList;

public class ChartRectIndicator1
extends IndicatorDrawable {
    private final String TAG = ChartRectIndicator1.class.getSimpleName();
    private final int mCount = 5;
    private float[] mAnimatedValue = new float[]{1.0f, 1.0f, 1.0f, 1.0f, 1.0f};
    private RectF rectF = new RectF();

    public ChartRectIndicator1(Context context, int indicatorColor, int indicatorSpeed) {
        Log.d((String)this.TAG, (String)"ChartRectIndicator1: ");
        this.indicatorColor = indicatorColor;
        this.indicatorSpeed = indicatorSpeed;
        if (indicatorSpeed <= 0) {
            this.indicatorSpeed = 1000;
        }
        this.init(context);
    }

    @Override
    protected void init(Context context) {
        Log.d((String)this.TAG, (String)"init: ");
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setStrokeWidth(ChartRectIndicator1.dip2px(context, 1.0f));
        this.mPaint.setColor(this.indicatorColor);
    }

    @Override
    protected ArrayList<Animator> getAnimation() {
        int[] delay = new int[]{100, 200, 300, 400, 500};
        ArrayList<Animator> list = new ArrayList<Animator>();
        for (int i = 0; i < 5; ++i) {
            final int index = i;
            ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.5f, 1.0f});
            valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator valueAnimator) {
                    ((ChartRectIndicator1)ChartRectIndicator1.this).mAnimatedValue[index] = ((Float)valueAnimator.getAnimatedValue()).floatValue();
                    ChartRectIndicator1.this.invalidateSelf();
                }
            });
            valueAnimator.setRepeatCount(-1);
            valueAnimator.setDuration((long)this.indicatorSpeed);
            valueAnimator.setStartDelay((long)delay[i]);
            list.add((Animator)valueAnimator);
        }
        return list;
    }

    @Override
    protected void draw(Canvas canvas, Paint paint) {
        float rectWidth;
        float rectSpace = rectWidth = (float)(this.getWidth() / 25);
        float startX = ((float)this.getWidth() - (rectWidth * 5.0f + rectSpace * 4.0f)) / 2.0f;
        float bottomY = (float)this.getHeight() / 1.5f;
        float rectMax = (float)this.getHeight() / 1.5f;
        for (int i = 0; i < 5; ++i) {
            canvas.save();
            this.rectF.setEmpty();
            this.rectF.set(startX + (float)i * (rectWidth + rectSpace), rectMax * this.mAnimatedValue[i], startX + (float)i * (rectWidth + rectSpace) + rectWidth, bottomY);
            canvas.drawRect(this.rectF, paint);
            canvas.restore();
        }
    }
}

