/*
 * Decompiled with CFR 0.152.
 */
package com.example.mzy.indicators.Circle;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.Log;
import android.view.animation.LinearInterpolator;
import com.example.mzy.indicators.IndicatorDrawable;
import java.util.ArrayList;

public class CircleTriangleIndicator
extends IndicatorDrawable {
    private final String TAG = CircleTriangleIndicator.class.getSimpleName();
    private float rotateAnimatedValue = 0.0f;
    private float scaleAnimatedValue = 0.0f;
    private boolean drawAssist = false;

    public CircleTriangleIndicator(Context context, int indicatorColor, int indicatorSpeed) {
        Log.d((String)this.TAG, (String)"CircleTriangleIndicator: ");
        this.indicatorColor = indicatorColor;
        this.indicatorSpeed = indicatorSpeed;
        if (indicatorSpeed <= 0) {
            this.indicatorSpeed = 1500;
        }
        this.init(context);
    }

    @Override
    protected void init(Context context) {
        Log.d((String)this.TAG, (String)"init: ");
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setStrokeWidth(CircleTriangleIndicator.dip2px(context, 1.0f));
        this.mPaint.setColor(this.indicatorColor);
    }

    @Override
    protected ArrayList<Animator> getAnimation() {
        ArrayList<Animator> list = new ArrayList<Animator>();
        ValueAnimator rotateAnimator = ValueAnimator.ofFloat((float[])new float[]{360.0f, 0.0f});
        rotateAnimator.setRepeatCount(-1);
        rotateAnimator.setDuration((long)this.indicatorSpeed);
        rotateAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        rotateAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                CircleTriangleIndicator.this.rotateAnimatedValue = ((Float)animation.getAnimatedValue()).floatValue();
                CircleTriangleIndicator.this.invalidateSelf();
            }
        });
        ValueAnimator scaleAnimator = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.3f, 1.0f});
        scaleAnimator.setRepeatCount(-1);
        scaleAnimator.setDuration((long)this.indicatorSpeed);
        scaleAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        scaleAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                CircleTriangleIndicator.this.scaleAnimatedValue = ((Float)animation.getAnimatedValue()).floatValue();
            }
        });
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playTogether(new Animator[]{rotateAnimator, scaleAnimator});
        list.add((Animator)animatorSet);
        return list;
    }

    @Override
    protected void draw(Canvas canvas, Paint paint) {
        this.drawAssist(canvas, paint);
        this.drawCircleTriangle(canvas, paint);
    }

    private void drawAssist(Canvas canvas, Paint paint) {
        if (this.drawAssist) {
            canvas.drawColor(-65536);
            canvas.drawLine((float)(this.getWidth() / 2), 0.0f, (float)(this.getWidth() / 2), (float)this.getHeight(), paint);
            canvas.drawLine(0.0f, (float)(this.getHeight() / 2), (float)this.getWidth(), (float)(this.getHeight() / 2), paint);
        }
    }

    private void drawCircleTriangle(Canvas canvas, Paint paint) {
        float sideLength = this.getWidth() / 5;
        float radius = this.getWidth() / 30;
        canvas.save();
        canvas.translate((float)(this.getWidth() / 2), (float)(this.getHeight() / 2));
        canvas.scale(this.scaleAnimatedValue, this.scaleAnimatedValue);
        canvas.rotate(this.rotateAnimatedValue);
        float xA = 0.0f;
        float yA = -((float)Math.sqrt(3.0)) * sideLength / 3.0f;
        float xB = -sideLength / 2.0f;
        float yB = (float)Math.sqrt(3.0) * sideLength / 6.0f;
        float xC = sideLength / 2.0f;
        float yC = (float)Math.sqrt(3.0) * sideLength / 6.0f;
        canvas.drawCircle(xA, yA, radius, paint);
        canvas.drawCircle(xB, yB, radius, paint);
        canvas.drawCircle(xC, yC, radius, paint);
        canvas.drawLine(xA, yA, xB, yB, paint);
        canvas.drawLine(xB, yB, xC, yC, paint);
        canvas.drawLine(xC, yC, xA, yA, paint);
        canvas.restore();
    }
}

