/*
 * Decompiled with CFR 0.152.
 */
package com.example.mzy.indicators.Circle;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.Log;
import android.view.animation.AccelerateInterpolator;
import com.example.mzy.indicators.IndicatorDrawable;
import java.util.ArrayList;

public class BasketBallIndicator
extends IndicatorDrawable {
    private final String TAG = BasketBallIndicator.class.getSimpleName();
    private float mAnimatedValue = 0.0f;

    public BasketBallIndicator(Context context, int indicatorColor, int indicatorSpeed) {
        Log.d((String)this.TAG, (String)"BasketBallIndicator: ");
        this.indicatorColor = indicatorColor;
        this.indicatorSpeed = indicatorSpeed;
        if (indicatorSpeed <= 0) {
            this.indicatorSpeed = 500;
        }
        this.init(context);
    }

    @Override
    protected void init(Context context) {
        Log.d((String)this.TAG, (String)"init: ");
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setStrokeWidth(BasketBallIndicator.dip2px(context, 1.0f));
        this.mPaint.setColor(this.indicatorColor);
    }

    @Override
    protected ArrayList<Animator> getAnimation() {
        ArrayList<Animator> list = new ArrayList<Animator>();
        ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{0.25f, 0.5f});
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                BasketBallIndicator.this.mAnimatedValue = ((Float)valueAnimator.getAnimatedValue()).floatValue();
                BasketBallIndicator.this.invalidateSelf();
            }
        });
        valueAnimator.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
        valueAnimator.setRepeatMode(2);
        valueAnimator.setRepeatCount(-1);
        valueAnimator.setDuration((long)this.indicatorSpeed);
        list.add((Animator)valueAnimator);
        return list;
    }

    @Override
    protected void draw(Canvas canvas, Paint paint) {
        canvas.save();
        this.drawBall(canvas, paint);
        this.drawInverted(canvas, paint);
        canvas.restore();
    }

    private void drawBall(Canvas canvas, Paint paint) {
        paint.setColor(this.indicatorColor);
        float x = this.getWidth() / 2;
        float move_y = (float)this.getHeight() * this.mAnimatedValue;
        float radius = this.getWidth() / 20;
        if (this.mAnimatedValue < 0.4f) {
            canvas.drawCircle(x, move_y, radius, paint);
        } else {
            RectF rectF = new RectF(x - radius, move_y - radius, x + radius, move_y + radius - 2.0f);
            canvas.drawOval(rectF, paint);
        }
    }

    private void drawInverted(Canvas canvas, Paint paint) {
        float x = this.getWidth() / 2;
        float ratio = (float)(((double)this.mAnimatedValue - 0.25) / 0.25);
        if ((double)ratio < 0.3) {
            return;
        }
        float radius = this.getWidth() / 10;
        float cut = radius * ratio * 0.6f;
        paint.setColor(-7829368);
        RectF rectF = new RectF(x - cut, (float)(this.getHeight() / 2) + radius * 0.5f, x + cut, (float)(this.getHeight() / 2) + radius * 0.7f);
        canvas.drawOval(rectF, paint);
    }
}

