/*
 * Decompiled with CFR 0.152.
 */
package com.example.mzy.indicators.Circle;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.Log;
import android.view.animation.LinearInterpolator;
import com.example.mzy.indicators.IndicatorDrawable;
import java.util.ArrayList;

public class ArcRotateIndicator
extends IndicatorDrawable {
    private final String TAG = ArcRotateIndicator.class.getSimpleName();
    private static final int IN_ANGLE = 90;
    private static final int OUT_ANGLE = 270;
    private float inRadius;
    private float outRadius;
    private RectF inRectF;
    private RectF outRectF;
    private float mAnimatedValue;

    public ArcRotateIndicator(Context context, int indicatorColor, int indicatorSpeed) {
        Log.d((String)this.TAG, (String)"ArcRotateIndicator: ");
        this.indicatorColor = indicatorColor;
        this.indicatorSpeed = indicatorSpeed;
        if (indicatorSpeed <= 0) {
            this.indicatorSpeed = 2000;
        }
        this.init(context);
    }

    @Override
    protected void init(Context context) {
        Log.d((String)this.TAG, (String)"init: ");
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeWidth(ArcRotateIndicator.dip2px(context, 1.0f));
        this.mPaint.setColor(this.indicatorColor);
        this.mPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mPaint.setStrokeJoin(Paint.Join.ROUND);
        this.mPaint.setDither(true);
        this.inRadius = ArcRotateIndicator.dip2px(context, 5.0f);
        this.outRadius = ArcRotateIndicator.dip2px(context, 10.0f);
    }

    @Override
    protected ArrayList<Animator> getAnimation() {
        ArrayList<Animator> list = new ArrayList<Animator>();
        ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                ArcRotateIndicator.this.mAnimatedValue = ((Float)valueAnimator.getAnimatedValue()).floatValue();
                ArcRotateIndicator.this.invalidateSelf();
            }
        });
        valueAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        valueAnimator.setRepeatCount(-1);
        valueAnimator.setDuration((long)this.indicatorSpeed);
        list.add((Animator)valueAnimator);
        return list;
    }

    @Override
    protected void draw(Canvas canvas, Paint paint) {
        if (this.inRectF == null || this.outRectF == null) {
            this.inRectF = new RectF();
            this.outRectF = new RectF();
            this.inRectF.set((float)(this.getWidth() / 2) - this.inRadius, (float)(this.getHeight() / 2) - this.inRadius, (float)(this.getWidth() / 2) + this.inRadius, (float)(this.getHeight() / 2) + this.inRadius);
            this.outRectF.set((float)(this.getWidth() / 2) - this.outRadius, (float)(this.getHeight() / 2) - this.outRadius, (float)(this.getWidth() / 2) + this.outRadius, (float)(this.getHeight() / 2) + this.outRadius);
        }
        int rotateAngle = (int)(360.0f * this.mAnimatedValue);
        canvas.save();
        canvas.drawArc(this.inRectF, (float)(rotateAngle % 360), 90.0f, false, paint);
        canvas.drawArc(this.outRectF, (float)(270 - rotateAngle % 360), 270.0f, false, paint);
        canvas.restore();
    }
}

