/*
 * Decompiled with CFR 0.152.
 */
package com.example.mzy.indicators.Circle;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.Log;
import android.view.animation.LinearInterpolator;
import com.example.mzy.indicators.IndicatorDrawable;
import java.util.ArrayList;

public class JumpIndicator
extends IndicatorDrawable {
    private final String TAG = JumpIndicator.class.getSimpleName();
    private final int mCount = 3;
    private float space;
    private float radius;
    private float leftPadding;
    private float[] mAnimatedValue = new float[]{0.0f, 0.0f, 0.0f};

    public JumpIndicator(Context context) {
        Log.d((String)this.TAG, (String)"JumpIndicator: ");
        this.init(context);
    }

    @Override
    protected void init(Context context) {
        Log.d((String)this.TAG, (String)"init: ");
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setStrokeWidth(1.0f);
        this.mPaint.setColor(-1);
        this.space = JumpIndicator.dip2px(context, 2.0f);
    }

    @Override
    protected ArrayList<Animator> getAnimation() {
        int[] delay = new int[]{100, 400, 800};
        ArrayList<Animator> list = new ArrayList<Animator>();
        for (int i = 0; i < 3; ++i) {
            final int index = i;
            ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f, 0.0f, -1.0f, 0.0f});
            valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator valueAnimator) {
                    ((JumpIndicator)JumpIndicator.this).mAnimatedValue[index] = ((Float)valueAnimator.getAnimatedValue()).floatValue();
                    if (JumpIndicator.this.mAnimatedValue[index] <= 0.0f) {
                        ((JumpIndicator)JumpIndicator.this).mAnimatedValue[index] = 0.0f;
                    }
                    JumpIndicator.this.invalidateSelf();
                }
            });
            valueAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
            valueAnimator.setRepeatCount(-1);
            valueAnimator.setDuration(2000L);
            valueAnimator.setStartDelay((long)delay[i]);
            list.add((Animator)valueAnimator);
        }
        return list;
    }

    @Override
    protected void draw(Canvas canvas, Paint paint) {
        if (this.leftPadding == 0.0f) {
            this.radius = this.getWidth() / 25;
            this.leftPadding = ((float)this.getWidth() - this.radius * 2.0f * 3.0f + this.space * 2.0f) / 2.0f;
        }
        for (int i = 0; i < 3; ++i) {
            float x = this.leftPadding + this.radius * (float)((i + 1) * 2 - 1) + this.space * (float)i;
            float y = (float)(this.getHeight() / 2) - (float)(this.getHeight() / 4) * this.mAnimatedValue[i];
            canvas.drawCircle(x, y, this.radius, paint);
        }
    }
}

