/*
 * Decompiled with CFR 0.152.
 */
package com.example.mzy.indicators.Rect;

import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.Log;
import com.example.mzy.indicators.IndicatorDrawable;
import java.util.ArrayList;

public class ChartRectIndicator1
extends IndicatorDrawable {
    private final String TAG = ChartRectIndicator1.class.getSimpleName();
    private final int mCount = 5;
    private float[] mAnimatedValue = new float[]{1.0f, 1.0f, 1.0f, 1.0f, 1.0f};
    private RectF rectF = new RectF();

    public ChartRectIndicator1(Context context) {
        Log.d((String)this.TAG, (String)"ChartRectIndicator1: ");
        this.init(context);
    }

    @Override
    protected void init(Context context) {
        Log.d((String)this.TAG, (String)"init: ");
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setStrokeWidth(1.0f);
        this.mPaint.setColor(-1);
    }

    @Override
    protected ArrayList<ValueAnimator> getAnimation() {
        int[] delay = new int[]{100, 200, 300, 400, 500};
        ArrayList<ValueAnimator> list = new ArrayList<ValueAnimator>();
        for (int i = 0; i < 5; ++i) {
            final int index = i;
            ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.5f, 1.0f});
            valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator valueAnimator) {
                    ((ChartRectIndicator1)ChartRectIndicator1.this).mAnimatedValue[index] = ((Float)valueAnimator.getAnimatedValue()).floatValue();
                    ChartRectIndicator1.this.invalidateSelf();
                }
            });
            valueAnimator.setRepeatCount(-1);
            valueAnimator.setDuration(1000L);
            valueAnimator.setStartDelay((long)delay[i]);
            list.add(valueAnimator);
        }
        return list;
    }

    @Override
    protected void draw(Canvas canvas, Paint paint) {
        float rectWidth;
        float rectSpace = rectWidth = (float)(this.getWidth() / 25);
        float startX = ((float)this.getWidth() - (rectWidth * 5.0f + rectSpace * 4.0f)) / 2.0f;
        float bottomY = (float)this.getHeight() / 1.5f;
        float rectMax = (float)this.getHeight() / 1.5f;
        for (int i = 0; i < 5; ++i) {
            canvas.save();
            this.rectF.setEmpty();
            this.rectF.set(startX + (float)i * (rectWidth + rectSpace), rectMax * this.mAnimatedValue[i], startX + (float)i * (rectWidth + rectSpace) + rectWidth, bottomY);
            canvas.drawRect(this.rectF, paint);
            canvas.restore();
        }
    }
}

