/*
 * Decompiled with CFR 0.152.
 */
package com.example.mzy.indicators;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import com.example.mzy.indicators.Circle.ArcRotateIndicator;
import com.example.mzy.indicators.Circle.ArcScaleRotateIndicator;
import com.example.mzy.indicators.Circle.BallScaleIndicator;
import com.example.mzy.indicators.Circle.BasketBallIndicator;
import com.example.mzy.indicators.Circle.CollisionIndicator;
import com.example.mzy.indicators.Circle.DropIndicator;
import com.example.mzy.indicators.IndicatorDrawable;
import com.example.mzy.indicators.R;
import com.example.mzy.indicators.Rect.ChartRectIndicator1;
import com.example.mzy.indicators.Rect.ChartRectIndicator2;
import com.example.mzy.indicators.Rect.ParallelogramIndicator;
import com.example.mzy.indicators.Star.StarIndicator;

public class LoadingIndicator
extends View {
    private final String TAG = LoadingIndicator.class.getSimpleName();
    private int mMinWidth;
    private int mMaxWidth;
    private int mMinHeight;
    private int mMaxHeight;
    private String indicatorName;
    private IndicatorDrawable mIndicator;

    public LoadingIndicator(Context context) {
        super(context);
        this.init(context, null, 0, 0);
    }

    public LoadingIndicator(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs, 0, R.style.LoadingIndicator);
    }

    public LoadingIndicator(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr, R.style.LoadingIndicator);
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.LoadingIndicator, defStyleAttr, defStyleRes);
        this.mMinWidth = ta.getDimensionPixelSize(R.styleable.LoadingIndicator_minWidth, 60);
        this.mMaxWidth = ta.getDimensionPixelSize(R.styleable.LoadingIndicator_maxWidth, 60);
        this.mMinHeight = ta.getDimensionPixelSize(R.styleable.LoadingIndicator_minHeight, 60);
        this.mMaxHeight = ta.getDimensionPixelSize(R.styleable.LoadingIndicator_maxHeight, 60);
        this.indicatorName = ta.getString(R.styleable.LoadingIndicator_indicatorName);
        ta.recycle();
        Log.d((String)this.TAG, (String)("init: density=" + context.getResources().getDisplayMetrics().density));
        Log.d((String)this.TAG, (String)("init: mMinWidth=" + this.mMinWidth + ", mMaxWidth=" + this.mMaxWidth));
        Log.d((String)this.TAG, (String)("init: mMinHeight=" + this.mMinHeight + ", mMaxHeight=" + this.mMaxHeight));
        Log.d((String)this.TAG, (String)("init: indicatorName=" + this.indicatorName));
        IndicatorDrawable indicatorDrawable = this.getIndicator(this.indicatorName, context);
        if (indicatorDrawable == null) {
            Log.e((String)this.TAG, (String)"init: indicatorDrawable==null");
            indicatorDrawable = new BasketBallIndicator(context);
        }
        indicatorDrawable.setCallback((Drawable.Callback)this);
        this.mIndicator = indicatorDrawable;
    }

    public IndicatorDrawable getIndicator(String indicatorName, Context context) {
        if (TextUtils.isEmpty((CharSequence)indicatorName)) {
            return null;
        }
        if ("BasketBallIndicator".equals(indicatorName)) {
            return new BasketBallIndicator(context);
        }
        if ("StarIndicator".equals(indicatorName)) {
            return new StarIndicator(context);
        }
        if ("BallScaleIndicator".equals(indicatorName)) {
            return new BallScaleIndicator(context);
        }
        if ("DropIndicator".equals(indicatorName)) {
            return new DropIndicator(context);
        }
        if ("CollisionIndicator".equals(indicatorName)) {
            return new CollisionIndicator(context);
        }
        if ("ChartRectIndicator1".equals(indicatorName)) {
            return new ChartRectIndicator1(context);
        }
        if ("ChartRectIndicator2".equals(indicatorName)) {
            return new ChartRectIndicator2(context);
        }
        if ("ArcRotateIndicator".equals(indicatorName)) {
            return new ArcRotateIndicator(context);
        }
        if ("ArcScaleRotateIndicator".equals(indicatorName)) {
            return new ArcScaleRotateIndicator(context);
        }
        if ("ParallelogramIndicator".equals(indicatorName)) {
            return new ParallelogramIndicator(context);
        }
        return null;
    }

    protected boolean verifyDrawable(Drawable who) {
        return who == this.mIndicator || super.verifyDrawable(who);
    }

    public void invalidateDrawable(Drawable dr) {
        if (this.verifyDrawable(dr)) {
            Rect dirty = dr.getBounds();
            int scrollX = this.getScrollX() + this.getPaddingLeft();
            int scrollY = this.getScrollY() + this.getPaddingTop();
            this.invalidate(dirty.left + scrollX, dirty.top + scrollY, dirty.right + scrollX, dirty.bottom + scrollY);
        } else {
            super.invalidateDrawable(dr);
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int saveCount = canvas.save();
        this.mIndicator.draw(canvas);
        canvas.restoreToCount(saveCount);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.updateDrawableBounds(w, h);
    }

    private void updateDrawableBounds(int w, int h) {
        Log.d((String)this.TAG, (String)("updateDrawableBounds: w=" + (w -= this.getPaddingRight() + this.getPaddingLeft()) + ", h=" + (h -= this.getPaddingTop() + this.getPaddingBottom())));
        int left = 0;
        int top = 0;
        int right = w;
        int bottom = h;
        if (this.mIndicator != null) {
            float boundAspect;
            int intrinsicHeight;
            int intrinsicWidth = this.mIndicator.getIntrinsicWidth();
            float intrinsicAspect = (float)intrinsicWidth / (float)(intrinsicHeight = this.mIndicator.getIntrinsicHeight());
            if (intrinsicAspect != (boundAspect = (float)w / (float)h)) {
                if (boundAspect > intrinsicAspect) {
                    int width = (int)((float)h * intrinsicAspect);
                    left = (w - width) / 2;
                    right = left + width;
                } else {
                    int height = (int)((float)w * (1.0f / intrinsicAspect));
                    top = (h - height) / 2;
                    bottom = top + height;
                }
            }
            Log.d((String)this.TAG, (String)("updateDrawableBounds: left=" + left + ", top=" + top + ", right=" + right + ", bottom=" + bottom));
            this.mIndicator.setBounds(left, top, right, bottom);
        }
    }

    protected synchronized void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int dw = 0;
        int dh = 0;
        IndicatorDrawable d = this.mIndicator;
        if (d != null) {
            dw = Math.max(this.mMinWidth, Math.min(this.mMaxWidth, d.getIntrinsicWidth()));
            dh = Math.max(this.mMinHeight, Math.min(this.mMaxHeight, d.getIntrinsicHeight()));
        }
        int measuredWidth = LoadingIndicator.resolveSizeAndState((int)(dw += this.getPaddingLeft() + this.getPaddingRight()), (int)widthMeasureSpec, (int)0);
        int measuredHeight = LoadingIndicator.resolveSizeAndState((int)(dh += this.getPaddingTop() + this.getPaddingBottom()), (int)heightMeasureSpec, (int)0);
        this.setMeasuredDimension(measuredWidth, measuredHeight);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.startAnimation();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.stopAnimation();
    }

    private void startAnimation() {
        if (this.getVisibility() != 0) {
            return;
        }
        Log.d((String)this.TAG, (String)"startAnimation: ");
        this.mIndicator.start();
        this.postInvalidate();
    }

    private void stopAnimation() {
        Log.d((String)this.TAG, (String)"stopAnimation: ");
        this.mIndicator.stop();
        this.postInvalidate();
    }
}

