/*
 * Decompiled with CFR 0.152.
 */
package com.example.mzy.indicators.Circle;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.Log;
import android.view.animation.LinearInterpolator;
import com.example.mzy.indicators.IndicatorDrawable;
import java.util.ArrayList;

public class DoubleArcIndicator
extends IndicatorDrawable {
    private final String TAG = DoubleArcIndicator.class.getSimpleName();
    private static final int IN_ANGLE = 90;
    private static final int OUT_ANGLE = 270;
    private float inRadius;
    private float outRadius;
    private RectF inRectF;
    private RectF outRectF;
    private float mAnimatedValue;

    public DoubleArcIndicator(Context context) {
        Log.d((String)this.TAG, (String)"DoubleArcIndicator: ");
        this.init(context);
    }

    @Override
    protected void init(Context context) {
        Log.d((String)this.TAG, (String)"init: ");
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeWidth(5.0f);
        this.mPaint.setColor(-1);
        this.mPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mPaint.setStrokeJoin(Paint.Join.ROUND);
        this.mPaint.setDither(true);
        this.inRadius = DoubleArcIndicator.dip2px(context, 5.0f);
        this.outRadius = DoubleArcIndicator.dip2px(context, 10.0f);
    }

    @Override
    protected ArrayList<ValueAnimator> getAnimation() {
        ArrayList<ValueAnimator> list = new ArrayList<ValueAnimator>();
        ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                DoubleArcIndicator.this.mAnimatedValue = ((Float)valueAnimator.getAnimatedValue()).floatValue();
                DoubleArcIndicator.this.invalidateSelf();
            }
        });
        valueAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        valueAnimator.setRepeatCount(-1);
        valueAnimator.setDuration(2000L);
        list.add(valueAnimator);
        return list;
    }

    @Override
    protected void draw(Canvas canvas, Paint paint) {
        if (this.inRectF == null || this.outRectF == null) {
            this.inRectF = new RectF();
            this.outRectF = new RectF();
            this.inRectF.set((float)(this.getWidth() / 2) - this.inRadius, (float)(this.getHeight() / 2) - this.inRadius, (float)(this.getWidth() / 2) + this.inRadius, (float)(this.getHeight() / 2) + this.inRadius);
            this.outRectF.set((float)(this.getWidth() / 2) - this.outRadius, (float)(this.getHeight() / 2) - this.outRadius, (float)(this.getWidth() / 2) + this.outRadius, (float)(this.getHeight() / 2) + this.outRadius);
        }
        int rotateAngle = (int)(360.0f * this.mAnimatedValue);
        canvas.save();
        canvas.drawArc(this.inRectF, (float)(rotateAngle % 360), 90.0f, false, paint);
        canvas.drawArc(this.outRectF, (float)(270 - rotateAngle % 360), 270.0f, false, paint);
        canvas.restore();
    }
}

